import { Injectable } from '@angular/core';
import {Router, CanActivate} from '@angular/router';

import { Logger } from '../logger.service';
import { AuthDataService } from '../../shared/auth-data.service';

const log = new Logger('AuthenticationGuard');

@Injectable()
export class AuthenticationGuard implements CanActivate {

  constructor(private router: Router, private authDataService: AuthDataService) { }

  canActivate() {
    const isAuthenticated = this.authDataService.authToken !== null;
    if (isAuthenticated) {
      return true;
    }

    this.router.navigate(['/login'], { replaceUrl: true });
    return false;
  }
}
