import { Injectable } from '@angular/core';
import {HttpEvent, HttpInterceptor, HttpHandler, HttpRequest, HttpEventType} from '@angular/common/http';
import { Observable } from 'rxjs';
import { Logger } from '../logger.service';
import {map} from 'rxjs/operators';

const log = new Logger('DataParserInterceptor');

/**
 * Adds a default error handler to all requests.
 */
@Injectable()
export class DataParserInterceptor implements HttpInterceptor {

  intercept(request: HttpRequest<any>, next: HttpHandler): Observable<HttpEvent<any>> {
    return next.handle(request).pipe(
      map((response) => {
        if (response.type === HttpEventType.Response && response.body.data) {
            return response.clone({ body: response.body.data });
        } else {
          return response;
        }
      }));
  }
}
