import { Route as ngRoute, Routes } from '@angular/router';

import { ShellComponent } from './shell/shell.component';
import { AuthenticationGuard } from './authentication/authentication.guard';
import {AuthComponent} from '@app/auth/auth.component';

/**
 * Provides helper methods to create routes.
 */
export class Route {

  /**
   * Creates routes using the shell component and authentication.
   * @param routes The routes to add.
   * @return {Route} The new route using shell as the base.
   */
  static withShell(routes: Routes): ngRoute {
    return {
      path: '',
      component: ShellComponent,
      children: routes,
      canActivate: [AuthenticationGuard],
      // Reuse ShellComponent instance when navigating between child views
      data: { reuse: true }
    };
  }


  static withAuthShell(routes: Routes): Routes {
    return [{
      path: '',
      component: AuthComponent,
      children: routes,
      // Reuse AuthComponent instance when navigating between child views
      data: { reuse: true, routeReuseIdentifier: 'auth' }
    }];
  }
}
