import {Component, Input, OnInit} from '@angular/core';
import {HeaderOption} from '@app/core/shell/shell.component';
import * as Color from 'color';
import { OrganisationsDataService } from '../../../organisations/organisations-data.service';
import { Organisation } from '../../../shared/models/organisation.model';

@Component({
  selector: 'app-sidebar',
  templateUrl: './sidebar.component.html',
  styleUrls: ['./sidebar.component.scss']
})
export class SidebarComponent implements OnInit {
  @Input() options: HeaderOption[] = [];
  primaryColor: Color = new Color("#008cd6");
  collapsed: boolean = false;

  constructor(private organisationService: OrganisationsDataService) { }

  ngOnInit() {
    this.organisationService.organisationChanged.subscribe((org: Organisation) => {
      this.primaryColor = org?.primaryColor ?? Color("#008cd6");
    });
  }

  getBestTextColor(): string {
    return Color(this.primaryColor).isLight() ? "#111" : "#fff";
  }

  getBestLogoStyle(): string {
    return Color(this.primaryColor).isLight() ? "invert(100%)" : null;
  }

  getBorderColor(): string {
    return Color(this.primaryColor).darken(0.2).string();
  }
}
