import { Component, OnInit, Input, Output, EventEmitter } from "@angular/core";
import { Event } from "@app/shared/models/event.model";

@Component({
  selector: "app-event-card",
  template: `
    <div class="card">
      <div style="text-align: left; background-color: #f8f8f8; padding: 15px;" class="card-img-top">
        <strong>{{ event.name }}</strong>
      </div>
      <div class="card-body">
        <dl *ngIf="(event.start | dutchDate) !== (event.end | dutchDate)">
          <dt>Data</dt>
          <dd>{{ event.start | dutchDate }} &ndash; {{ event.end | dutchDate }}</dd>
        </dl>
        <dl *ngIf="(event.start | dutchDate) === (event.end | dutchDate)">
          <dt>Datum</dt>
          <dd style="font-size: 150%;">{{ event.start | dutchDate }}</dd>
        </dl>
      </div>
      <div class="card-footer">
        <button appClickStopPropagation (click)="onToggleArchive()" class="btn btn-light">
          {{ event.archived ? "Activeren" : "Archiveren" }}
        </button>
      </div>
    </div>
  `,
  styleUrls: ["./event-card.component.scss"]
})
export class EventCardComponent {
  @Input() event: Event;
  @Output() toggleArchive = new EventEmitter();

  constructor() {}

  onToggleArchive() {
    console.log(this.event);
    this.toggleArchive.emit();
  }
}
