import {Component, OnDestroy, OnInit} from '@angular/core';
import {ActivatedRoute} from "@angular/router";
import {EventsDataService} from "@app/events/events-data.service";
import {Event} from "@app/shared/models/event.model";
import {OrganisationsDataService} from "@app/organisations/organisations-data.service";

@Component({
  selector: 'app-wrapper-detail',
  templateUrl: './event-wrapper.component.html',
  styleUrls: ['./event-wrapper.component.scss']
})
export class EventWrapperComponent implements OnInit {
  lastLoadedEventId = "";
  lastLoadedEvent: Event = null;

  constructor(
    private route: ActivatedRoute,
    private eventService: EventsDataService,
    private organisationsService: OrganisationsDataService
  ) { }

  ngOnInit() {
    this.route.params.subscribe(params => {
      if (params.eventId !== this.lastLoadedEventId) {
        this.lastLoadedEventId = params.eventId;
        this.eventService.getByIdForOrganisation(this.organisationsService.currentOrganisation.id, params.eventId).subscribe(event => {
          this.eventService.currentEvent = event;
          this.lastLoadedEvent = event;
        });
      }
    });
  }
}
