import { NgModule } from '@angular/core';
import { CommonModule } from '@angular/common';
import { TranslateModule } from '@ngx-translate/core';

import { CoreModule } from 'app/core/index';
import { SharedModule } from 'app/shared/index';
import {EventsComponent} from '@app/events/events.component';
import {EventDetailComponent} from '@app/events/detail/event-detail.component';
import {EventsDataService} from '@app/events/events-data.service';
import { EventDetailPlanningComponent } from './planning/event-detail-planning.component';
import { CompaniesDataService } from '../companies/companies-data.service';
import {WarningsModalComponent} from '@app/events/planning/warnings-modal/warnings-modal.component';
import { EventCompaniesComponent } from './companies/event-companies.component';
import { EventWrapperComponent } from './event-wrapper/event-wrapper.component';
import { EventCardComponent } from './event-card/event-card.component';

@NgModule({
  imports: [
    CommonModule,
    TranslateModule,
    CoreModule,
    SharedModule
  ],
  declarations: [
    EventsComponent,
    EventDetailComponent,
    EventDetailPlanningComponent,
    WarningsModalComponent,
    EventCompaniesComponent,
    EventCardComponent
  ],
  providers: [EventsDataService, CompaniesDataService],
  entryComponents: [WarningsModalComponent]
})
export class EventsModule { }
