import { Component, Input, OnInit } from '@angular/core';
import { NgbActiveModal } from '@ng-bootstrap/ng-bootstrap';
import { Warnings } from '@angular/cli/lib/config/schema';
import { Warning } from '@app/shared/models/warning.model';
import { Group } from '@app/shared/models/group.model';
import { Company } from '@app/shared/models/company.model';

@Component({
  selector: 'app-delete-modal',
  templateUrl: 'warnings-modal.component.html',
})
export class WarningsModalComponent implements OnInit {
  @Input() warnings: Warning[];
  filteredWarnings: Warning[];
  codeFilters: string[] = ['overlapping', 'required', 'unassigned', 'overCapacity', 'outsideEvent', 'noAddress'];
  codeFilterOptions: string[] = ['overlapping', 'required', 'unassigned', 'overCapacity', 'outsideEvent', 'noAddress'];

  @Input() counts: { [code: string]: number } = null;

  @Input() companies: Company[];
  @Input() groups: Group[];

  constructor(public activeModal: NgbActiveModal) {}

  ngOnInit() {
    this.filterWarnings();
  }

  companyById(id: string) {
    return this.companies.find((c) => c.id === id);
  }

  groupById(id: string) {
    return this.groups.find((g) => g.id === id);
  }

  prettyWarningLabel(code: string, addCount: boolean = false) {
    const countString = addCount && this.counts ? ' (' + (this.counts[code] || 0) + ')' : '';

    switch (code) {
      case 'overlapping':
        return 'Overlap' + countString;
      case 'required':
        return 'Verplicht' + countString;
      case 'unassigned':
        return 'Niet toegewezen' + countString;
      case 'overCapacity':
        return 'Capaciteit' + countString;
      case 'outsideEvent':
        return 'Buiten evenement' + countString;
      case 'noAddress':
        return 'Ontbrekend adres' + countString;
      default:
        return 'Overig';
    }
  }

  filterWarnings() {
    this.filteredWarnings = this.warnings.filter((w) => this.codeFilters.includes(w.code));
  }

  filterClicked(opt: string) {
    if (this.codeFilters.find((f) => opt === f)) {
      this.codeFilters.splice(
        this.codeFilters.findIndex((f) => opt === f),
        1
      );
    } else {
      this.codeFilters.push(opt);
    }
    this.filterWarnings();
  }
}
