import { Component, OnInit, OnDestroy } from "@angular/core";
import { CompaniesDataService } from "@app/companies/companies-data.service";
import { Organisation } from "@app/shared/models/organisation.model";
import { OrganisationsDataService } from "../organisations-data.service";
import { ActivatedRoute, Router } from "@angular/router";
import { Subscription } from "rxjs";
import { EmailsDataService } from "@app/shared/emails/emails-data.service";
import { EmailBatch } from "@app/shared/emails/email-batch.model";
import { SchoolsDataService } from "@app/schools/schools-data.service";

@Component({
  selector: "app-communication-center",
  templateUrl: "./communication-center.component.html",
  styleUrls: ["./communication-center.component.scss"]
})
export class CommunicationCenterComponent implements OnInit, OnDestroy {
  organisation: Organisation;
  showFullMessage = false;
  filter = "organisation";
  filterId = "";
  dataSubscription: Subscription;
  routerSubscription: Subscription;
  selected: string = null;

  batches: EmailBatch[];

  hasChildRoutes = false;
  batchId = "";

  page = 0;
  allMessagesLoaded = false;
  isNewMessageRoute = false;

  constructor(
    private schoolService: SchoolsDataService,
    private companyService: CompaniesDataService,
    private emailsService: EmailsDataService,
    private organisationsService: OrganisationsDataService,
    private route: ActivatedRoute,
    private router: Router
  ) {}

  ngOnInit() {
    this.organisation = this.organisationsService.currentOrganisation;
    this.dataSubscription = this.route.data.subscribe(data => {
      this.filter = data["filter"];
      switch (this.filter) {
        case "company":
          this.filterId = this.companyService.currentCompany.id;
          break;
        case "school":
          this.filterId = this.schoolService.currentSchool.id;
          break;
      }

      this.emailsService
        .getAllBatchesForOrganisation(this.organisation.id, this.filter, this.filterId, this.page)
        .subscribe(batches => (this.batches = batches));
    });

    this.hasChildRoutes = this.route.children.length > 0;
    this.isNewMessageRoute = window.location.href.includes("/nieuw");
    if (this.hasChildRoutes && this.route.children[0].snapshot.params["batchId"]) {
      this.batchId = this.route.children[0].snapshot.params["batchId"];
    }

    this.routerSubscription = this.router.events.subscribe(() => {
      this.hasChildRoutes = this.route.children.length > 0;
      this.isNewMessageRoute = window.location.href.includes("/nieuw");
      this.batchId = "";
      if (this.hasChildRoutes && this.route.children[0].snapshot.params["batchId"]) {
        this.batchId = this.route.children[0].snapshot.params["batchId"];
      }
    });
  }

  ngOnDestroy() {
    this.dataSubscription.unsubscribe();
    this.routerSubscription.unsubscribe();
  }

  goToBatchDetail(batchId: string) {
    this.router.navigate(["/organisaties", this.organisation.id, "communicatie", batchId]);
    this.selected = batchId;
  }

  loadMore() {
    this.page++;
    this.emailsService
      .getAllBatchesForOrganisation(this.organisation.id, this.filter, this.filterId, this.page)
      .subscribe(batches => {
        if (batches.length === 0) {
          // Limit reached, hide button
          this.allMessagesLoaded = true;
        } else {
          this.batches = this.batches.concat(batches);
        }
      });
  }
}
