import { Component, OnInit, Input } from "@angular/core";
import { EmailBatch } from "@app/shared/emails/email-batch.model";

@Component({
  selector: "app-email-batch-list-item",
  template: `
    <div class="batch-wrapper card">
      <div class="card-header">
        <h5 class="card-title">{{ batch.name }}</h5>
        <div class="status-row">
          <div class="status-item" placement="top" ngbTooltip="Verstuurd op">
            <i class="fa fa-paper-plane"></i> {{ batch.sentAt | dutchDate: true }}
          </div>
          <div class="status-item" placement="top" ngbTooltip="Laatste activiteit">
            <i class="fa fa-history"></i> {{ batch.lastActivity | dutchDate: true }}
          </div>
          <div class="status-item-small" placement="top" ngbTooltip="Totaal verstuurd">
            <i class="fa fa-inbox"></i> {{ batch.totalEmails }}
          </div>
          <div class="status-item-small" placement="top" ngbTooltip="Ongelezen">
            <i class="fa fa-envelope"></i> {{ batch.unreadEmails }}
          </div>
        </div>
      </div>
    </div>
  `,
  styleUrls: ["./email-batch-list-item.component.scss"]
})
export class EmailBatchListItemComponent implements OnInit {
  @Input() batch: EmailBatch;

  constructor() {}

  ngOnInit() {}
}
