import {Injectable} from '@angular/core';
import {HttpClient} from '@angular/common/http';

import {Observable} from 'rxjs';
import {map} from 'rxjs/operators';

import {Location} from '@app/shared/models/location.model';

// Manually defined because of old TS
type Omit<T, K extends keyof any> = Pick<T, Exclude<keyof T, K>>;

@Injectable()
export class LocationsDataService {
  constructor(private http: HttpClient) { }

  getAllForOrganisation(organisationId: string): Observable<Location[]> {
    return this.http.get<Location[]>(`/organisations/${organisationId}/locations`).pipe(
      map((entities) => entities.sort((a, b) => (a.name.toLowerCase() < b.name.toLowerCase() ? -1 : 1)))
    );
  }

  addToOrganisation(organisationId: string, entity: Omit<Location, "id">): Observable<Location> {
    return this.http.post<Location>(`/organisations/${organisationId}/locations`, entity);
  }

  updateInOrganisation(organisationId: string, entity: Partial<Location>) {
    return this.http.put<Location>(`/organisations/${organisationId}/locations/${entity.id}`, entity);
  }

  deleteFromOrganisation(organisationId: string, entityId: string): Observable<void> {
    return this.http.delete<void>(`/organisations/${organisationId}/locations/${entityId}`);
  }
}
