import {Injectable} from '@angular/core';
import {HttpClient} from '@angular/common/http';

import {Observable} from 'rxjs';
import {Message} from '@app/shared/models/message.model';

@Injectable()
export class MessagesDataService {
  constructor(private http: HttpClient) { }

  static idFromRecipient(recipient: any) {
    switch (recipient.type) {
      case 'organisation': return "organisation";
      case 'visitors': return !recipient.company ? recipient.companyId : recipient.company.id;
      case 'group': return !recipient.group ? recipient.groupId : recipient.group.id;
      case 'user': return !recipient.user ? recipient.userId : recipient.user.id;
      case 'school': return !recipient.school ? recipient.schoolId : recipient.school.id;
      case 'event': return !recipient.event ? recipient.eventId : recipient.event.id;
    }
    return null;
  }

  getAllForOrganisation(organisationId: string): Observable<Message[]> {
    return this.http.get<Message[]>(`/organisations/${organisationId}/messages`);
  }

  addToOrganisation(organisationId: string, entity: Message): Observable<Message> {
    return this.http.post<Message>(`/organisations/${organisationId}/messages`, entity);
  }

  send(organisationId: string, entity: Message): Observable<Message> {
    return this.http.post<Message>(`/organisations/${organisationId}/messages/${entity.id}/send`, {});
  }

  getByIdForOrganisation(organisationId: string, messageId: string): Observable<Message> {
    return this.http.get<Message>(`/organisations/${organisationId}/messages/${messageId}`);
  }

  addRecipientToMessage(organisationId: string, messageId: string, recipient: any): Observable<any> {
    return this.http.post<any>(`/organisations/${organisationId}/messages/${messageId}/recipients`, recipient);
  }

  removeRecipientFromMessage(organisationId: string, messageId: string, recipient: any): Observable<void> {
    return this.http.delete<void>(`/organisations/${organisationId}/messages/${messageId}/recipients/${recipient.id}`);
  }

  updateInOrganisation(organisationId: string, entity: Partial<Message>) {
    return this.http.put<Message>(`/organisations/${organisationId}/messages/${entity.id}`, entity);
  }

  deleteFromOrganisation(organisationId: string, entityId: string): Observable<void> {
    return this.http.delete<void>(`/organisations/${organisationId}/messages/${entityId}`);
  }
}
