import { Component, OnInit } from '@angular/core';
import {ActivatedRoute} from "@angular/router";
import {OrganisationsDataService} from "@app/organisations/organisations-data.service";
import {Organisation} from "@app/shared/models/organisation.model";

@Component({
  selector: 'app-organisation-wrapper',
  templateUrl: './organisation-wrapper.component.html',
  styleUrls: ['./organisation-wrapper.component.scss']
})
export class OrganisationWrapperComponent implements OnInit {
  lastLoadedOrganisationId = "";
  lastLoadedOrganisation: Organisation = null;

  constructor(
    private route: ActivatedRoute,
    private organisationService: OrganisationsDataService,
  ) { }

  ngOnInit() {
    this.route.params.subscribe(params => {
      if (params.organisationId !== this.lastLoadedOrganisationId) {
        this.lastLoadedOrganisationId = params.organisationId;
        this.organisationService.getById(params.organisationId).subscribe(organisation => {
          this.organisationService.currentOrganisation = organisation;
          this.lastLoadedOrganisation = organisation;
        });
      }
    });
  }
}
