import { NgModule } from "@angular/core";
import { CommonModule } from "@angular/common";
import { TranslateModule } from "@ngx-translate/core";

import { CoreModule } from "@app/core";
import { SharedModule } from "@app/shared";
import { OrganisationsDataService } from "@app/organisations/organisations-data.service";
import { MessagesComponent } from "./messages/messages.component";
import { FeedbackComponent } from "./feedback/feedback.component";
import { OrganisationsListComponent } from "./list/organisations-list.component";
import { OrganisationLocationsComponent } from "./locations/organisation-locations.component";
import { LocationsDataService } from "@app/organisations/locations/locations-data.service";
import { OrganisationsMembersComponent } from "./members/organisations-members.component";
import { MessagesDataService } from "@app/organisations/messages/messages-data.service";
import { RecipientModalComponent } from "@app/organisations/messages/recipient-modal/recipient-modal.component";
import { TemplatesComponent } from "./templates/templates.component";
import { TemplatesDataService } from "./templates/templates-data.service";
import { NgbTooltipModule } from "@ng-bootstrap/ng-bootstrap";
import { CommunicationCenterComponent } from "./communication-center/communication-center.component";
import { EmailBatchComponent } from "./communication-center/email-batch/email-batch.component";
import { RouterModule } from "@angular/router";
import { EmailBatchListItemComponent } from "./communication-center/email-batch-list-item/email-batch-list-item.component";
import { EmailThreadComponent } from "./communication-center/email-batch/email-thread/email-thread.component";
import { EmailComposerComponent } from './communication-center/email-composer/email-composer.component';

@NgModule({
  imports: [CommonModule, TranslateModule, CoreModule, SharedModule, NgbTooltipModule, RouterModule],
  declarations: [
    MessagesComponent,
    FeedbackComponent,
    OrganisationsListComponent,
    OrganisationLocationsComponent,
    OrganisationsMembersComponent,
    RecipientModalComponent,
    TemplatesComponent,
    CommunicationCenterComponent,
    EmailBatchComponent,
    EmailBatchListItemComponent,
    EmailThreadComponent,
    EmailComposerComponent
  ],
  providers: [OrganisationsDataService, LocationsDataService, MessagesDataService, TemplatesDataService],
  entryComponents: [RecipientModalComponent]
})
export class OrganisationsModule {}
