import { Injectable } from "@angular/core";
import { HttpClient } from "@angular/common/http";

import { Observable } from "rxjs";
import { Template, TemplateType } from "@app/shared/models/template.model";
import { map, flatMap } from "rxjs/operators";

export interface TemplatesPerType {
  type: string;
  name: string;
  description: string;
  templates: Template[];
}

export interface RenderedTemplate {
  subject: string;
  body: string;
}

@Injectable()
export class TemplatesDataService {
  constructor(private http: HttpClient) {}

  getAllForOrganisation(organisationId: string): Observable<TemplatesPerType[]> {
    return this.http.get<TemplatesPerType[]>(`/organisations/${organisationId}/templates`);
  }

  updateInOrganisation(organisationId: string, entity: Partial<Template>) {
    return this.http.put<Template>(`/organisations/${organisationId}/templates/${entity.id}`, entity);
  }

  addToOrganisation(organisationId: string, entity: Template): Observable<Template> {
    return this.http.post<Template>(`/organisations/${organisationId}/templates`, entity);
  }

  getByIdForOrganisation(organisationId: string, templateId: string): Observable<Template> {
    return this.http.get<Template>(`/organisations/${organisationId}/templates/${templateId}`);
  }

  getVariablesForType(organisationId: string, type: string): Observable<TemplateType> {
    return this.http.get<TemplateType>(`/organisations/${organisationId}/templates/types/${type}`);
  }

  getRenderedHtml(organisationId: string, templateId: string): Observable<RenderedTemplate> {
    const response = this.http.get<RenderedTemplate>(`/organisations/${organisationId}/templates/${templateId}/render`);
    console.log(response);
    return response;
  }

  deleteFromOrganisation(organisationId: string, entityId: string): Observable<void> {
    return this.http.delete<void>(`/organisations/${organisationId}/templates/${entityId}`);
  }
}
