import {Component, OnInit, ViewChild} from '@angular/core';
import {NgbModal} from '@ng-bootstrap/ng-bootstrap';
import {SchoolsDataService} from '../schools-data.service';
import {NotificationsService} from 'angular2-notifications';
import {DeleteModalComponent} from 'app/shared/delete-modal/modal.component';
import {DatatableComponent} from '@swimlane/ngx-datatable';
import {Title} from '@angular/platform-browser';
import {Batch} from '@app/shared/models/batch.model';
import * as moment from 'moment';
import {OrganisationsDataService} from "@app/organisations/organisations-data.service";
import {School} from "@app/shared/models/school.model";
import {Organisation} from "@app/shared/models/organisation.model";

@Component({
  selector: 'app-batches',
  templateUrl: './batches.component.html',
  styleUrls: ['./batches.component.scss']
})
export class BatchesComponent implements OnInit {
  batches: Batch[] = [];
  selected: any[] = [];
  organisation: Organisation = null;
  school: School = null;
  @ViewChild(DatatableComponent) table: DatatableComponent;

  constructor(private modal: NgbModal,
              private schoolsService: SchoolsDataService,
              private organisationsService: OrganisationsDataService,
              private title: Title,
              private toast: NotificationsService) {
  }

  ngOnInit() {
    this.organisation = this.organisationsService.currentOrganisation;

    this.school = this.schoolsService.currentSchool;
    this.title.setTitle(`Scholen > ${this.school.name} > Batches`);
    this.getMembers();
  }

  getMembers() {
    this.schoolsService.getBatches(this.organisation.id, this.school.id)
      .subscribe((batches) => {
        this.batches = batches;
      });
  }

  rowClicked(event: any) {
    this.deletePressed(event.selected[0]);
  }

  deletePressed(batch: Batch) {
    const modalRef = this.modal.open(DeleteModalComponent);
    const component = modalRef.componentInstance as DeleteModalComponent;
    component.name = `Batch ${batch.batch}`;
    modalRef.result.then((result) => {
      this.schoolsService.deleteBatch(this.organisation.id, this.school.id, `${batch.batch}`).subscribe(() => {
        this.toast.success(`Batch is verwijderd.`);
        this.getMembers();
      });
    }).catch(() => {
    });
  }

  formatDate(date: Date) {
    return moment(date).format("LLLL");
  }
}
