import {Component, OnInit} from '@angular/core';
import {ActivatedRoute} from "@angular/router";
import {SchoolsDataService} from "@app/schools/schools-data.service";
import {School} from "@app/shared/models/school.model";
import {OrganisationsDataService} from "@app/organisations/organisations-data.service";

@Component({
  selector: 'app-school-wrapper',
  templateUrl: './school-wrapper.component.html',
  styleUrls: ['./school-wrapper.component.scss']
})
export class SchoolWrapperComponent implements OnInit {
  lastLoadedSchoolId = "";
  lastLoadedSchool: School = null;

  constructor(
    private route: ActivatedRoute,
    private schoolService: SchoolsDataService,
    private organisationsService: OrganisationsDataService
  ) { }

  ngOnInit() {
    this.route.params.subscribe(params => {
      if (params.schoolId !== this.lastLoadedSchoolId) {
        this.lastLoadedSchoolId = params.schoolId;
        this.schoolService.getByIdForOrganisation(this.organisationsService.currentOrganisation.id, params.schoolId).subscribe(school => {
          this.schoolService.currentSchool = school;
          this.lastLoadedSchool = school;
        });
      }
    });
  }
}
