import { NgModule } from '@angular/core';
import { CommonModule } from '@angular/common';
import { TranslateModule } from '@ngx-translate/core';

import { CoreModule } from '@app/core';
import { SharedModule } from '@app/shared';
import { SchoolDetailComponent } from '@app/schools/detail/school-detail.component';
import { SchoolsDataService } from '@app/schools/schools-data.service';
import { GroupsComponent } from './groups/groups.component';
import { MembersComponent } from './members/members.component';
import { ImporterComponent } from './importer/importer.component';
import { ProgressBarComponent } from './importer/progress-bar/progress-bar.component';
import {ImporterService} from '@app/schools/importer/importer.service';
import { GroupDetailComponent } from './groups/detail/group-detail.component';
import { SchoolsListComponent } from './list/schools-list.component';
import { BatchesComponent } from './batches/batches.component';

@NgModule({
  imports: [
    CommonModule,
    TranslateModule,
    CoreModule,
    SharedModule
  ],
  declarations: [
    SchoolDetailComponent, GroupsComponent,
    MembersComponent, ImporterComponent, ProgressBarComponent,
    GroupDetailComponent, SchoolsListComponent, BatchesComponent
  ],
  providers: [SchoolsDataService, ImporterService]
})
export class SchoolsModule { }
