import {Injectable, EventEmitter} from '@angular/core';
import { Person } from './models/person.model';

export interface LoginResponseAuthToken {
  createdAt: Date;
  expiresAt: Date;
  token: string;
  updatedAt: Date;
  userId: string;
}

export interface LoginResponseUser {
  admin: boolean;
  createdAt: Date;
  id: string;
  lastActiveAt: Date;
  updatedAt: Date;​​
  username: string;
  person: Person;
}

export interface LoginResponse {
  authToken: LoginResponseAuthToken;
  user: LoginResponseUser;
  permissions: any;
}

@Injectable({
  providedIn: "root"
})
export class AuthDataService {
  permissions: any = null;
  authToken: LoginResponseAuthToken | null = null;
  user: LoginResponseUser | null = null;
  triggerLogout = new EventEmitter();
}
