import { Injectable } from '@angular/core';
import {CanActivate} from '@angular/router';
import { AuthDataService } from './auth-data.service';

@Injectable()
export class AuthenticationGuard implements CanActivate {

  constructor(private authDataService: AuthDataService) { }

  canActivate() {
    return this.authDataService.user?.admin ?? false;
  }

}
