import {FormGroup} from '@angular/forms';
import {NgbModal} from '@ng-bootstrap/ng-bootstrap';
import {DeleteModalComponent} from '@app/shared/delete-modal/modal.component';
import {Entity} from '@app/shared/models/entity.model';
import {DatatableComponent} from '@swimlane/ngx-datatable';
import {ViewChild} from '@angular/core';

export class CrudComponent<EntityType extends Entity> {
  crudForm: FormGroup;

  temp: EntityType[] = [];
  entities: EntityType[] = [];
  selected: any[] = [];
  @ViewChild(DatatableComponent) table: DatatableComponent;

  modalService: NgbModal;

  constructor() { }

  initialize(modalService: NgbModal) {
    this.modalService = modalService;

    this.createForm();
  }

  deleteEntity(entity: EntityType) {
    throw new Error("needs to be implemented");
  }

  // Override this.
  protected createForm() { }

  // Override this.
  editPressed(entity: EntityType) {  }

  deletePressed(entity: EntityType) {
    const modalRef = this.modalService.open(DeleteModalComponent);
    modalRef.componentInstance.name = entity.name;
    modalRef.result.then((result) => {
      this.deleteEntity(entity);
    }).catch(() => {});
  }

  updateFilter(event: any) {
    const val = event.target.value.toLowerCase();

    // filter the rows
    this.entities = this.temp.filter(d => {
      return d.name.toLowerCase().indexOf(val) !== -1 || !val;
    });
    // Whenever the filter changes, always go back to the first page
    this.table.offset = 0;
  }
}
