import {Component, Input, OnInit} from '@angular/core';
import {NgbActiveModal} from '@ng-bootstrap/ng-bootstrap';

@Component({
  selector: 'app-delete-modal',
  template: `<div class="modal-header">
      <h4 class="modal-title">{{name}} verwijderen?</h4>
      <button type="button" class="close" aria-label="Close" (click)="activeModal.dismiss('Cross click')">
        <span aria-hidden="true">&times;</span>
      </button>
    </div>
    <div class="modal-footer">
      <button type="button" class="btn btn-outline-dark" (click)="activeModal.dismiss('Cancel click')">
        Annuleren
      </button>
      <button type="button" class="btn btn-danger" (click)="activeModal.close('Confirm click')">
        Verwijderen
      </button>
    </div>
  `
})
export class DeleteModalComponent {
  @Input() name = "";

  constructor(public activeModal: NgbActiveModal) {}
}
