export const EmailStatuses = {
  sent: {
    translation: "Verzonden",
    tooltip: "Vanuit het systeem verzonden, nog geen verdere status bekend"
  },
  delivered: { translation: "Afgeleverd", tooltip: "Afgeleverd bij ontvanger" },
  opened: { translation: "Geopend", tooltip: "Geopend door ontvanger" },
  clicked: { translation: "Aangeklikt", tooltip: "Ontvanger heeft iets aangeklikt" },
  delayed: { translation: "Vertraagd", tooltip: "Mail is vertraagd, nog niet aangekomen" },
  rejected: { translation: "Geweigerd", tooltip: "Mail is geweigerd door ontvanger" }
};

export const renderEmail = (innerHtml: string) => {
  return `<body style="background-color:#eeeeee;">
  <div style="background-color:#eeeeee;">
      <!--[if mso | IE]>  <table     align="center" border="0" cellpadding="0" cellspacing="0" class="" style="width:600px;" width="600"  >    <tr>      <td style="line-height:0px;font-size:0px;mso-line-height-rule:exactly;">  <![endif]-->
      <div style="Margin:0px auto;max-width:600px;">
          <table align="center" border="0" cellpadding="0" cellspacing="0" role="presentation" style="width:100%;">
              <tbody>
                  <tr>
                      <td style="direction:ltr;font-size:0px;padding:20px 0;padding-bottom:0;text-align:center;vertical-align:top;">
                          <!--[if mso | IE]>              <table role="presentation" border="0" cellpadding="0" cellspacing="0">                <tr>          <td           class="" style="vertical-align:top;width:600px;"        >      <![endif]-->
                          <div class="mj-column-per-100 outlook-group-fix" style="font-size:13px;text-align:left;direction:ltr;display:inline-block;vertical-align:top;width:100%;">
                              <table border="0" cellpadding="0" cellspacing="0" role="presentation" style="vertical-align:top;" width="100%">
                                  <tr>
                                      <td align="center" style="font-size:0px;padding:10px 25px;word-break:break-word;">
                                          <div style="font-family:Ubuntu, Helvetica, Arial, sans-serif;font-size:13px;line-height:1;text-align:center;color:#bbbbbb;"> Deze mail is automatisch verstuurd. U kunt niet op dit bericht reageren. </div>
                                      </td>
                                  </tr>
                              </table>
                          </div>
                          <!--[if mso | IE]>        </td>          </tr>                </table>            <![endif]-->
                      </td>
                  </tr>
              </tbody>
          </table>
      </div>
      <!--[if mso | IE]>      </td>    </tr>  </table>    <table     align="center" border="0" cellpadding="0" cellspacing="0" class="" style="width:600px;" width="600"  >    <tr>      <td style="line-height:0px;font-size:0px;mso-line-height-rule:exactly;">  <![endif]-->
      <div style="background:#008cd6;background-color:#008cd6;Margin:0px auto;max-width:600px;">
          <table align="center" border="0" cellpadding="0" cellspacing="0" role="presentation" style="background:#008cd6;background-color:#008cd6;width:100%;">
              <tbody>
                  <tr>
                      <td style="direction:ltr;font-size:0px;padding:20px 0;text-align:center;vertical-align:top;">
                          <!--[if mso | IE]>              <table role="presentation" border="0" cellpadding="0" cellspacing="0">                <tr>          <td           class="" style="vertical-align:top;width:600px;"        >      <![endif]-->
                          <div class="mj-column-per-100 outlook-group-fix" style="font-size:13px;text-align:left;direction:ltr;display:inline-block;vertical-align:top;width:100%;">
                              <table border="0" cellpadding="0" cellspacing="0" role="presentation" style="vertical-align:top;" width="100%">
                                  <tr>
                                      <td align="center" style="font-size:0px;padding:10px 25px;word-break:break-word;">
                                          <table border="0" cellpadding="0" cellspacing="0" role="presentation" style="border-collapse:collapse;border-spacing:0px;">
                                              <tbody>
                                                  <tr>
                                                      <td style="width:200px;">
                                                          <a href="https://jongerenbedrijvendag.nl" target="_blank"> <img height="auto" src="https://portal.jongerenbedrijvendag.nl/assets/jbd_logo.png" style="border:0;display:block;outline:none;text-decoration:none;height:auto;width:100%;" width="200" /> </a>
                                                      </td>
                                                  </tr>
                                              </tbody>
                                          </table>
                                      </td>
                                  </tr>
                              </table>
                          </div>
                          <!--[if mso | IE]>        </td>          </tr>                </table>            <![endif]-->
                      </td>
                  </tr>
              </tbody>
          </table>
      </div>
      <!--[if mso | IE]>      </td>    </tr>  </table>    <table     align="center" border="0" cellpadding="0" cellspacing="0" class="" style="width:600px;" width="600"  >    <tr>      <td style="line-height:0px;font-size:0px;mso-line-height-rule:exactly;">  <![endif]-->
      <div style="background:#ffffff;background-color:#ffffff;Margin:0px auto;max-width:600px;">
          <table align="center" border="0" cellpadding="0" cellspacing="0" role="presentation" style="background:#ffffff;background-color:#ffffff;width:100%;">
              <tbody>
                  <tr>
                      <td style="direction:ltr;font-size:0px;padding:20px 0;text-align:center;vertical-align:top;">
                          <!--[if mso | IE]>              <table role="presentation" border="0" cellpadding="0" cellspacing="0">                <tr>          <td           class="" style="vertical-align:top;width:600px;"        >      <![endif]-->
                          <div class="mj-column-per-100 outlook-group-fix" style="font-size:13px;text-align:left;direction:ltr;display:inline-block;vertical-align:top;width:100%;">
                              <table border="0" cellpadding="0" cellspacing="0" role="presentation" style="vertical-align:top;" width="100%">
                                  <tr>
                                      <td align="left" style="font-size:0px;padding:10px 25px;word-break:break-word;">
                                          <div style="font-family:Ubuntu, Helvetica, Arial, sans-serif;font-size:13px;line-height:1;text-align:left;color:#000000;">
                                              ${innerHtml}
                                          </div>
                                      </td>
                                  </tr>
                              </table>
                          </div>
                          <!--[if mso | IE]>        </td>          </tr>                </table>            <![endif]-->
                      </td>
                  </tr>
              </tbody>
          </table>
      </div>
      <!--[if mso | IE]>      </td>    </tr>  </table>    <table     align="center" border="0" cellpadding="0" cellspacing="0" class="" style="width:600px;" width="600"  >    <tr>      <td style="line-height:0px;font-size:0px;mso-line-height-rule:exactly;">  <![endif]-->
      <div style="Margin:0px auto;max-width:600px;">
          <table align="center" border="0" cellpadding="0" cellspacing="0" role="presentation" style="width:100%;">
              <tbody>
                  <tr>
                      <td style="direction:ltr;font-size:0px;padding:20px 0;padding-bottom:0px;text-align:center;vertical-align:top;">
                          <!--[if mso | IE]>              <table role="presentation" border="0" cellpadding="0" cellspacing="0">                <tr>          <td           class="" style="vertical-align:top;width:600px;"        >      <![endif]-->
                          <div class="mj-column-per-100 outlook-group-fix" style="font-size:13px;text-align:left;direction:ltr;display:inline-block;vertical-align:top;width:100%;">
                              <table border="0" cellpadding="0" cellspacing="0" role="presentation" style="vertical-align:top;" width="100%">
                                  <tr>
                                      <td align="center" style="font-size:0px;padding:10px 25px;word-break:break-word;">
                                          <div style="font-family:Ubuntu, Helvetica, Arial, sans-serif;font-size:13px;line-height:1;text-align:center;color:#bbbbbb;"> Download de app </div>
                                      </td>
                                  </tr>
                              </table>
                          </div>
                          <!--[if mso | IE]>        </td>          </tr>                </table>            <![endif]-->
                      </td>
                  </tr>
              </tbody>
          </table>
      </div>
      <!--[if mso | IE]>      </td>    </tr>  </table>    <table     align="center" border="0" cellpadding="0" cellspacing="0" class="" style="width:600px;" width="600"  >    <tr>      <td style="line-height:0px;font-size:0px;mso-line-height-rule:exactly;">  <![endif]-->
      <div style="Margin:0px auto;max-width:600px;">
          <table align="center" border="0" cellpadding="0" cellspacing="0" role="presentation" style="width:100%;">
              <tbody>
                  <tr>
                      <td style="direction:ltr;font-size:0px;padding:20px 0;padding-top:0px;text-align:center;vertical-align:top;">
                          <!--[if mso | IE]>              <table role="presentation" border="0" cellpadding="0" cellspacing="0">                <tr>          <td           class="" style="vertical-align:top;width:300px;"        >      <![endif]-->
                          <div class="mj-column-per-50 outlook-group-fix" style="font-size:13px;text-align:left;direction:ltr;display:inline-block;vertical-align:top;width:100%;">
                              <table border="0" cellpadding="0" cellspacing="0" role="presentation" style="vertical-align:top;" width="100%">
                                  <tr>
                                      <td align="right" style="font-size:0px;padding:10px 25px;word-break:break-word;">
                                          <table border="0" cellpadding="0" cellspacing="0" role="presentation" style="border-collapse:collapse;border-spacing:0px;">
                                              <tbody>
                                                  <tr>
                                                      <td style="width:153px;">
                                                          <a href="https://play.google.com/store/apps/details?id=nl.jongerenbedrijvendag.app&pcampaignid=MKT-Other-global-all-co-prtnr-py-PartBadge-Mar2515-1" target="_blank"> <img alt="Ontdek het op Google Play" height="46" src="https://play.google.com/intl/en_us/badges/images/badge_new.png" style="border:0;display:block;outline:none;text-decoration:none;height:46px;width:100%;" width="153" /> </a>
                                                      </td>
                                                  </tr>
                                              </tbody>
                                          </table>
                                      </td>
                                  </tr>
                              </table>
                          </div>
                          <!--[if mso | IE]>        </td>              <td           class="" style="vertical-align:top;width:300px;"        >      <![endif]-->
                          <div class="mj-column-per-50 outlook-group-fix" style="font-size:13px;text-align:left;direction:ltr;display:inline-block;vertical-align:top;width:100%;">
                              <table border="0" cellpadding="0" cellspacing="0" role="presentation" style="vertical-align:top;" width="100%">
                                  <tr>
                                      <td align="left" style="font-size:0px;padding:10px 25px;padding-top:11px;word-break:break-word;">
                                          <table border="0" cellpadding="0" cellspacing="0" role="presentation" style="border-collapse:collapse;border-spacing:0px;">
                                              <tbody>
                                                  <tr>
                                                      <td style="width:136px;">
                                                          <a href="https://itunes.apple.com/us/app/jongeren-bedrijvendag/id1449743976?l=nl&ls=1&mt=8&ign-mscache=1" target="_blank"> <img alt="Download in de App Store" height="45" src="https://developer.apple.com/app-store/marketing/guidelines/images/badge-example-preferred.png" style="border:0;display:block;outline:none;text-decoration:none;height:45px;width:100%;" width="136" /> </a>
                                                      </td>
                                                  </tr>
                                              </tbody>
                                          </table>
                                      </td>
                                  </tr>
                              </table>
                          </div>
                          <!--[if mso | IE]>        </td>          </tr>                </table>            <![endif]-->
                      </td>
                  </tr>
              </tbody>
          </table>
      </div>
      <!--[if mso | IE]>      </td>    </tr>  </table>    <table     align="center" border="0" cellpadding="0" cellspacing="0" class="" style="width:600px;" width="600"  >    <tr>      <td style="line-height:0px;font-size:0px;mso-line-height-rule:exactly;">  <![endif]-->
      <div style="Margin:0px auto;max-width:600px;">
          <table align="center" border="0" cellpadding="0" cellspacing="0" role="presentation" style="width:100%;">
              <tbody>
                  <tr>
                      <td style="direction:ltr;font-size:0px;padding:20px 0;text-align:center;vertical-align:top;">
                          <!--[if mso | IE]>              <table role="presentation" border="0" cellpadding="0" cellspacing="0">                <tr>      </tr>                </table>            <![endif]-->
                      </td>
                  </tr>
              </tbody>
          </table>
      </div>
      <!--[if mso | IE]>      </td>    </tr>  </table>  <![endif]-->
  </div>
</body>`;
};

export class Email {
  id: string;
  subject: string;
  body: string;
  batchId?: string;
  status: string;
  statusChangedAt: Date;
  sentAt: Date;
  senderName: string;
  senderEmail: string;
  recipientName: string;
  recipientEmail: string;
  unreadCount?: number;
  replyCount?: number;
  read: boolean;
}
