import {Component, OnInit, Input, Output, EventEmitter} from '@angular/core';
import {FormGroup} from '@angular/forms';
import {Address} from '@app/shared/models/address.model';

export class DropdownOption {
  constructor(public value: string | number, public label: string) {}
}

export class DropdownOptionGroup {
  constructor(public title: string, public options: DropdownOption[]) {}
}

@Component({
  selector: 'app-form-input',
  templateUrl: './form-input.component.html',
  styleUrls: ['./form-input.component.scss']
})
export class FormInputComponent implements OnInit {
  @Input() controlId: string;
  @Input() type = "text";
  @Input() options: DropdownOption[] = [];
  @Input() optionGroups: DropdownOptionGroup[] = [];
  @Input() label: string;
  @Input() labelColor = "black";
  @Input() showLabel = true;
  @Input() group: FormGroup;
  @Input() size: number;
  @Input() disabled = false;
  @Output() change: EventEmitter<any> = new EventEmitter<any>();

  ngOnInit() {
  }
}
