import {Person} from 'app/shared/models/person.model';
import * as Color from 'color';
import {Entity} from '@app/shared/models/entity.model';
import {Category} from '@app/shared/models/category.model';
import {Address} from '@app/shared/models/address.model';
import {Image} from '@app/shared/models/image.model';

export class Company extends Entity {
  // contact: Person;
  address: Address;

  phoneNumber: string;

  images: Image[];

  logo = "https://placehold.it/300x300";
  linkingCode = "";
  info = "";
  notes = "";
  website = "";
  recommendedCourses: string[] = [];
  recommendedStudies: string[] = [];
  categories: Category[] = [];

  canModify?: boolean;

  facebook?: string;
  instagram?: string;
  linkedin?: string;
  allowPublic: boolean;
  employees?: string;
  sector?: string;
  email?: string;

  mailOpened: boolean;
  mailSentOn?: Date;
}
