import {PredefinedSlot} from '@app/shared/models/predefined-slot.model';
import { Location } from './location.model';
import { Company } from './company.model';
import { School } from './school.model';
import * as moment from "moment";
import * as Color from "color";

const slotColors = {
  company: Color("#3498db").lighten(0.2),
  location: Color("#2ecc71").lighten(0.2),
  school: Color("#e74c3c").lighten(0.2),
  required: Color("#5b3f34").lighten(0.8),
  template: "#888",
  unassigned: "#bdc3c7"
};

export { slotColors };

export class Slot extends PredefinedSlot {
  travelMode: string;
  location?: Location;
  company?: Company;
  school?: School;

  constructor({ id, name, type, start, end, travelMode, location, company, school }: Slot) {
    super();

    this.id = id;
    this.name = name;
    this.type = type;
    this.start = start;
    this.end = end;
    this.travelMode = travelMode;
    this.location = location;
    this.company = company;
    this.school = school;
  }

  get cardContent() {
    const content: any = {};

    switch (this.travelMode) {
      case "driving":
        content.icon = "fas fa-car";
      break;
      case "walking":
        content.icon = "fa fa-walking";
      break;
      case "bicycling":
        content.icon = "fa fa-bicycle";
      break;
      case "transit":
        content.icon = "fa fa-train";
      break;
    }

    content.time = moment(this.start).format("HH:mm") + " - " + moment(this.end).format("HH:mm");

    if (this.company) {
      content.title = `${this.company.name}`;
      content.color = slotColors.company;
    } else if (this.location) {
      content.title = `${this.location.name}`;
      content.color = slotColors.location;
    } else if (this.school) {
      content.title = `${this.school.name}`;
      content.color = slotColors.school;
    } else if (this.type === "required") {
      content.title = `${this.name} (verplicht)`;
      content.color = slotColors.required;
    } else if (this.type === "template") {
      content.title = `${this.name} (sjabloon)`;
      content.color = slotColors.template;
    } else {
      content.title = `Nog niet toegewezen`;
      content.color = slotColors.unassigned;
    }

    return content;
  }
}
