import { Entity } from "./entity.model";

export const templateTypeOptions = [
  { value: "general", label: "Algemene template" },
  { value: "companyEventInfo", label: "Evenementinfo voor bedrijf" },
  { value: "accountCreated", label: "Nieuw account aangemaakt" },
  { value: "organisationAdminAdded", label: "Organisatie beheerder toegevoegd" },
  { value: "organisationGuideAdded", label: "Organisatie begeleider toegevoegd" },
  { value: "schoolAdminCreated", label: "School beheerder toegevoegd" },
  { value: "schoolGuideCreated", label: "School begeleider toegevoegd" }
];

export class TemplateTypeVariable {
  bodyOnly: boolean;
  description: string;
  example: string;
  name: string;
  required: boolean;
}

export class TemplateType {
  name: string;
  description: string;
  example: string;
  bodyOnly: boolean;
  required: boolean;
  type?: string;
  variables?: {
    global: TemplateTypeVariable[];
    specific: TemplateTypeVariable[];
  };
}

export class Template extends Entity {
  type: TemplateType;
  subject: string;
  body: string;
  primary: boolean;
  autoGenerated: boolean;
}
