import { Pipe, PipeTransform } from '@angular/core';
import * as moment from 'moment';
moment.locale('nl');

@Pipe({name: 'dutchDate'})
export class DutchDatePipe implements PipeTransform {
  transform(value: Date, withTime: boolean = false): string {
    return moment(value).format("LL" + (withTime ? "LL" : ""));
  }
}
