import { Pipe, PipeTransform } from '@angular/core';
import * as moment from 'moment';
moment.locale('nl');

@Pipe({name: 'isoDate'})
export class IsoDatePipe implements PipeTransform {
  transform(value: Date): string {
    const m = moment(value);
    if (m.isValid()) {
      return m.format("YYYY-MM-DD");
    }

    return "";
  }
}
