import { Pipe, PipeTransform } from '@angular/core';
import * as moment from 'moment';
moment.locale('nl');

@Pipe({name: 'isoTime'})
export class IsoTimePipe implements PipeTransform {
  transform(value: Date): string {
    const m = moment(value);
    if (m.isValid()) {
      return m.format("HH:mm");
    }

    return "";
  }
}
