import { NgModule } from "@angular/core";
import { CommonModule } from "@angular/common";

import { LoaderComponent } from "./loader/loader.component";
import { TranslateModule } from "@ngx-translate/core";
import { NgbDatepickerConfig, NgbModule } from "@ng-bootstrap/ng-bootstrap";
import { FormsModule, ReactiveFormsModule } from "@angular/forms";

import { FullCalendarModule } from '@fullcalendar/angular'; // must go before plugins
import resourceTimelinePlugin from '@fullcalendar/resource-timeline';

import { FormInputComponent } from "@app/shared/forms/form-input/form-input.component";
import { AddressService } from "@app/shared/address.service";
import { DeleteModalComponent } from "@app/shared/delete-modal/modal.component";
import { NotificationsService } from "angular2-notifications";
import { BrowserAnimationsModule } from "@angular/platform-browser/animations";
import { ColorPickerModule } from "ngx-color-picker";
import { ClickStopPropagationDirective } from "@app/shared/click-stop-propagation.directive";
import { FormModalComponent } from "@app/shared/form-modal/form-modal.component";
import { BestTextColorPipe } from "@app/shared/pipes/best-text-color.pipe";
import { DutchDatePipe } from "@app/shared/pipes/dutch-date.pipe";

import { NgxLinkifyjsModule } from "ngx-linkifyjs";
import { ImageUploadModule } from "angular2-image-upload";
import { FullDatePipe } from "./pipes/full-date.pipe";
import { IsoTimePipe } from "./pipes/iso-time.pipe";
import { IsoDatePipe } from "./pipes/iso-date.pipe";
import { ImprovedRouterLinkDirective } from "@app/shared/improved-router-link.directive";
import { DragScrollModule } from "ngx-drag-scroll";
import { DragulaModule } from "ng2-dragula";
import { NgxDatatableModule } from "@swimlane/ngx-datatable";
import { NgxSpinnerModule } from "ngx-spinner";
import { QuillModule } from 'ngx-quill';

import { LightboxModule } from "ngx-lightbox";
import { MemberDetailComponent } from "@app/shared/member-detail/member-detail.component";
import { RouteModalComponent } from "./route-modal/route-modal.component";
import { SafeHtmlPipe } from "./safe-html.pipe";
import { EmailsDataService } from "./emails/emails-data.service";
import { AuthService } from './auth.service';
import { AuthDataService } from './auth-data.service';

const toolbarOptions = [
  ['bold', 'italic', 'underline', 'strike'],        // toggled buttons
  ['blockquote', 'code-block'],

  [{ 'header': 1 }, { 'header': 2 }],               // custom button values
  [{ 'list': 'ordered'}, { 'list': 'bullet' }],
  [{ 'script': 'sub'}, { 'script': 'super' }],      // superscript/subscript
  [{ 'indent': '-1'}, { 'indent': '+1' }],          // outdent/indent
  [{ 'direction': 'rtl' }],                         // text direction

  [{ 'size': ['small', false, 'large', 'huge'] }],  // custom dropdown
  [{ 'header': [1, 2, 3, 4, 5, 6, false] }],

  ['clean']                                         // remove formatting button
];

FullCalendarModule.registerPlugins([
  resourceTimelinePlugin,
]);
@NgModule({
  imports: [
    CommonModule,
    TranslateModule.forChild(),
    FullCalendarModule,
    NgbModule,
    ReactiveFormsModule,
    FormsModule,
    BrowserAnimationsModule,
    DragulaModule,
    NgxDatatableModule,
    ColorPickerModule,
    DragScrollModule,
    NgxLinkifyjsModule,
    ImageUploadModule,
    NgxSpinnerModule,
    LightboxModule,
    QuillModule.forRoot({
      modules: {
        history: {          // Enable with custom configurations
          delay: 2500,
          userOnly: true
        },
        toolbar: toolbarOptions
      }
    })
  ],
  declarations: [
    LoaderComponent,
    FormInputComponent,
    DeleteModalComponent,
    ClickStopPropagationDirective,
    ImprovedRouterLinkDirective,
    FormModalComponent,
    BestTextColorPipe,
    DutchDatePipe,
    FullDatePipe,
    IsoDatePipe,
    IsoTimePipe,
    SafeHtmlPipe,
    MemberDetailComponent,
    RouteModalComponent
  ],
  exports: [
    LoaderComponent,
    FormInputComponent,
    ReactiveFormsModule,
    FullCalendarModule,
    NgbModule,
    FormsModule,
    TranslateModule,
    ColorPickerModule,
    NgxDatatableModule,
    DragulaModule,
    NgxLinkifyjsModule,
    ImageUploadModule,
    DragScrollModule,
    QuillModule,
    ClickStopPropagationDirective,
    ImprovedRouterLinkDirective,
    DeleteModalComponent,
    BestTextColorPipe,
    DutchDatePipe,
    FullDatePipe,
    SafeHtmlPipe,
    IsoDatePipe,
    IsoTimePipe,
    NgxSpinnerModule,
    LightboxModule,
    MemberDetailComponent,
    RouteModalComponent
  ],
  providers: [
    NgbDatepickerConfig,
    AddressService,
    AuthService,
    AuthDataService,
    NotificationsService,
    EmailsDataService,
  ],
  entryComponents: [FormModalComponent, DeleteModalComponent, RouteModalComponent]
})
export class SharedModule {
  constructor(config: NgbDatepickerConfig) {
    // customize default values of datepickers used by this component tree
    config.minDate = { year: 1900, month: 1, day: 1 };
    const now = new Date(Date.now());
    config.maxDate = { day: now.getUTCDate(), month: now.getUTCMonth() + 1, year: now.getUTCFullYear() };

    // days that don't belong to current month are not visible
    config.outsideDays = "hidden";
  }
}
