import { Category, Address } from '.';

export interface Image {
  displayOrder: number;
  filename: string;
  description: string | null;
  id: string;
  title: string | null;
  companyId?: string;
  createdAt: string;
  updatedAt: string;
}

export interface CompanyListItem {
  id: string;
  name: string;
  primaryColor: string | null;
  logo: string | null;
  info: string | null;
  categories?: Category[];
}

export interface Company extends CompanyListItem {
  email: string;
  employees: number | null;
  facebook: string | null;
  instagram: string | null;
  linkedin: string | null;
  phoneNumber: string | null;
  recommendedCourses: string[];
  recommendedStudies: string[];
  sector: string | null;
  website: string | null;
  address: Address;
  images: Image[];
  isSponsor?: boolean;
  allowPublic?: boolean;
}
