import { Company, Group, Organisation, Event, School } from '.';
import { HasAccessLevel } from './has-access-level';
import { HasEvents } from './has-events';
import { HasSchools } from './has-groups';

type OrganisationWithSchoolsAndEvents = Organisation & HasSchools & HasEvents;

type SchoolWithOrganisation = School & { organisation: Organisation };
type GroupWithSchoolAndEvent = Group & { school: SchoolWithOrganisation } & {
  event: Event;
} & HasAccessLevel;

export interface Permissions {
  groups: GroupWithSchoolAndEvent[];
  schools: School[];
  events: Event[];
  organisations: Organisation[];
  companies: Company[];
  tree: OrganisationWithSchoolsAndEvents[];
  roles: string[];
}
