import { Company, Event } from '.';

export interface PollQuestionOption {
  id: string;
  questionId: string;
  title: string;
  displayOrder: number;
}

export interface PollQuestion {
  id: string;
  pollId: string;
  title: string;
  description: string;
  type: 'range' | 'selectOne' | 'open';
  rules: { min: number; max: number } | { maxLength: number } | null;
  displayOrder: number;
  options: PollQuestionOption[];
}

export interface Poll {
  description: string | null;
  id: string;
  processedAt: string;
  publishAt: string;
  title: string;
  type: 'event' | 'company';
  questions: PollQuestion[];
}

export interface PollMetadata {
  answers: unknown[];
  company: Company | null;
  createdAt: string;
  event: Event;
  id: string;
  respondedAt: string | null;
  poll: Poll;
}
