import { AxiosInstance } from 'axios';
import { Permissions, User } from '../models';

export interface LoginResponseDto {
  authToken: {
    createdAt: string;
    expiresAt: string;
    token: string;
    user: User;
  };
  permissions: Permissions;
  user: User;
}

export class AuthService {
  constructor(private axiosInstance: AxiosInstance) {}

  async login(username: string, password: string) {
    const { data } = await this.axiosInstance.post<LoginResponseDto>(
      '/auth/token',
      { username, password }
    );
    return data;
  }

  async logout() {
    return this.axiosInstance.delete('/auth/token', {});
  }

  async checkStatus() {
    const { data } = await this.axiosInstance.get<{
      success: true;
      data: LoginResponseDto;
    }>('/auth/me', {});
    return data.data;
  }
}
