import { PollMetadata, Route } from '../models';
import { AxiosInstance } from 'axios';

export class EventService {
  constructor(private axiosInstance: AxiosInstance) {}

  async getRoute(organisationId: string, eventId: string, groupId: string) {
    const { data } = await this.axiosInstance.get<{
      success: true;
      data: Route;
    }>(`/organisations/${organisationId}/events/${eventId}/routes/${groupId}`);
    return data.data;
  }

  async getFeedbackPolls(userId: string) {
    const { data } = await this.axiosInstance.get<{
      success: true;
      data: PollMetadata[];
    }>(`/users/${userId}/polls`);
    return data.data;
  }

  async getFeedbackPollById(userId: string, pollId: string) {
    const { data } = await this.axiosInstance.get<{
      success: true;
      data: PollMetadata;
    }>(`/users/${userId}/polls/${pollId}`);

    return data.data;
  }

  async submitPoll(userId: string, pollId: string, answers: any) {
    return this.axiosInstance.post(`/users/${userId}/polls/${pollId}/answers`, {
      answers,
    });
  }
}
