import { User } from '@jbd/end-user-business-logic';
import { AxiosInstance } from 'axios';
import { GroupMember } from '../models/group-member';

export class GroupService {
  constructor(private axiosInstance: AxiosInstance) {}

  async getMembers(
    organisationId: string,
    schoolId: string,
    groupId: string
  ): Promise<User[]> {
    const { data } = await this.axiosInstance.get<{
      success: boolean;
      data: GroupMember[];
    }>(
      `/organisations/${organisationId}/schools/${schoolId}/groups/${groupId}/members`
    );
    return data.data;
  }
}
