import { AxiosInstance } from 'axios';
import { Message } from '../models';

export class MessageService {
  constructor(private axiosInstance: AxiosInstance) {}

  async getMessages(userId: string): Promise<Message[]> {
    const { data } = await this.axiosInstance.get<{
      success: boolean;
      data: Message[];
    }>(`/users/${userId}/messages`);
    return data.data;
  }

  async getMessageById(userId: string, messageId: string): Promise<Message> {
    const { data } = await this.axiosInstance.get<{
      success: boolean;
      data: Message;
    }>(`/users/${userId}/messages/${messageId}`);

    return data.data;
  }

  async sendMessage(
    userId: string,
    groupId: string,
    subject: string,
    body: string
  ) {
    return this.axiosInstance.post(`/users/${userId}/messages`, {
      subject,
      body,
      groupId,
      type: 'group',
    });
  }
}
