import { AxiosInstance } from 'axios';
import { Organisation, Category, Company } from '../models';

export class PublicService {
  constructor(private axiosInstance: AxiosInstance) {}

  async getOrganisations(): Promise<Organisation[]> {
    const { data } = await this.axiosInstance.get<{
      success: boolean;
      data: Organisation[];
    }>('/public/organisations');
    return data.data;
  }

  async getCategoriesInOrganisation(
    organisationSlug: string
  ): Promise<Category[]> {
    const { data } = await this.axiosInstance.get<{
      success: boolean;
      data: Category[];
    }>(`/public/organisations/${organisationSlug}/categories`);
    return data.data;
  }

  async getCompaniesInOrganisation(
    organisationSlug: string
  ): Promise<Company[]> {
    const { data } = await this.axiosInstance.get<{
      success: boolean;
      data: Company[];
    }>(`/public/organisations/${organisationSlug}/companies`);
    return data.data;
  }

  async getCompanyInOrganisationById(
    organisationSlug: string,
    companyId: string
  ): Promise<Company> {
    const { data } = await this.axiosInstance.get<{
      success: boolean;
      data: Company;
    }>(`/public/organisations/${organisationSlug}/companies/${companyId}`);
    return data.data;
  }
}
