import { Person, User } from '@jbd/end-user-business-logic';
import { AxiosInstance } from 'axios';

export class UserService {
  constructor(private axiosInstance: AxiosInstance) {}

  async setPushNotificationToken(
    userId: string,
    pushNotificationToken: string
  ) {
    return this.axiosInstance.post(`/users/${userId}/push-tokens`, {
      token: pushNotificationToken,
    });
  }

  async deletePushNotificationToken(
    userId: string,
    pushNotificationToken: string
  ) {
    return this.axiosInstance.delete(
      `/users/${userId}/push-tokens/${encodeURIComponent(
        pushNotificationToken
      )}`
    );
  }

  async getPersonalData(userId: string): Promise<Person> {
    const { data } = await this.axiosInstance.get<{
      success: boolean;
      data: User;
    }>(`/users/${userId}`);
    return data.data.person;
  }

  async updatePersonalData(
    userId: string,
    person: Partial<Person>
  ): Promise<Person> {
    const { data } = await this.axiosInstance.put<User>(`/users/${userId}`, {
      person,
    });
    return data.person;
  }
}
