import { Permissions, User } from '@jbd/end-user-business-logic';
import { createContext, useContext } from 'react';

interface IAuthContext {
  isAuthenticated: boolean;
  user: User | null;
  permissions: Permissions;
  login(username: string, password: string): Promise<boolean>;
  logout(): void;
}

export const AuthContext = createContext<IAuthContext | null>(null);

export function useAuthentication() {
  // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
  const context = useContext(AuthContext)!;
  return context;
}
