import {
  Event,
  Group,
  Organisation,
  School,
} from '@jbd/end-user-business-logic';
import { createContext, useContext } from 'react';

interface IEventContext {
  event: Event;
  group: Group;
  school: School;
  organisation: Organisation;
}

export const EventContext = createContext<IEventContext | null>(null);

export const useEventContext = () => {
  // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
  return useContext(EventContext)!;
};
