import {
  EventService,
  GroupService,
  PublicService,
  UserService,
  AuthService,
  MessageService,
} from '@jbd/end-user-business-logic';
import { createContext, useContext } from 'react';

interface IServicesContext {
  eventService: EventService;
  groupService: GroupService;
  publicService: PublicService;
  userService: UserService;
  authService: AuthService;
  messageService: MessageService;
}

export const ServicesContext = createContext<IServicesContext | null>(null);

export const useServices = () => {
  // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
  return useContext(ServicesContext)!;
};
