import { AuthService } from '@jbd/end-user-business-logic';
import { createContext, useContext } from 'react';
import { PreviewService } from '.';

interface IPreviewServicesContext {
  authService: AuthService;
  previewService: PreviewService;
}

export const PreviewServicesContext =
  createContext<IPreviewServicesContext | null>(null);

export const usePreviewServices = () => {
  // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
  return useContext(PreviewServicesContext)!;
};
