import { Category, Company, Organisation } from '@jbd/end-user-business-logic';
import { AxiosInstance } from 'axios';

export class PreviewService {
  constructor(private axiosInstance: AxiosInstance) {}

  async getOrganisation(organisationId: string): Promise<Organisation> {
    const { data } = await this.axiosInstance.get<{
      success: boolean;
      data: Organisation;
    }>(`/organisations/${organisationId}`);
    return data.data;
  }

  async getCategoriesInOrganisation(
    organisationId: string
  ): Promise<Category[]> {
    const { data } = await this.axiosInstance.get<{
      success: boolean;
      data: Category[];
    }>(`/organisations/${organisationId}/categories`);
    return data.data;
  }

  async getCompaniesInOrganisation(organisationId: string): Promise<Company[]> {
    const { data } = await this.axiosInstance.get<{
      success: boolean;
      data: Company[];
    }>(`/organisations/${organisationId}/companies`);
    return data.data;
  }

  async getCompanyInOrganisationById(
    organisationId: string,
    companyId: string
  ): Promise<Company> {
    const { data } = await this.axiosInstance.get<{
      success: boolean;
      data: Company;
    }>(`/organisations/${organisationId}/companies/${companyId}`);
    return data.data;
  }
}
