/*
 * $Workfile:   tdiaddr.h  $ $Revision:   1.1  $ $Modtime:   14 Nov 1994 08:48:42  $
 *
 * Product		: WinXTI
 * Author		: Ian Parker
 *
 * FILE DESCRIPTION
 *	This header file contains extracts from tdi.h as supplied with the NT DDK
 *	(Daytona beta). It provided the TDI address structures used by NT Transport
 *	Providers. 
 *
 * MODIFICATION HISTORY
 *
 * $Log:   S:/masters/win32/include/tdiaddr.h_v  $
 * 
 *    Rev 1.1   14 Nov 1994 09:18:04   IANP
 * 
 * 
 *    Rev 1.0   07 Nov 1994 16:45:30   PSF
 * Initial_Revision
 * 
 *    Rev 1.0   28 Oct 1994 18:25:06   IANP
 * Added ISO_TSAP address and moved to include directory
 * 
 *    Rev 1.1   29 Sep 1994 11:48:12   IANP
 * Amended include protection
 * 
 *    Rev 1.0   22 Sep 1994 11:49:16   IANP
 * Initial_Revision
 *
 */

#ifndef _TDIADDR_H
#define _TDIADDR_H

#ifndef _TDI_USER_
//
// Basic type used to represent an address at the transport level. There may
// be many addresses represented in a single address structure. If there are
// multiple addresses, a given provider must understand all of them or it can
// use none of them. Note that it is acceptible for the provider to not know
// how to use the address, as long as it knows the address type. Thus, a
// TCP/IP NetBIOS provider may know both NetBIOS and TCP/IP addresses, but
// use only the NetBIOS address; the TCP/IP address would (likely) be passed on
// to the TCP/IP provider.
//

typedef struct _TA_ADDRESS {
    USHORT AddressLength;       // length in bytes of Address[] in this
    USHORT AddressType;         // type of this address
    UCHAR Address[1];           // actually AddressLength bytes long
} TA_ADDRESS, *PTA_ADDRESS;


typedef struct _TRANSPORT_ADDRESS {
    int TAAddressCount;             // number of addresses following
    TA_ADDRESS Address[1];          // actually TAAddressCount elements long
} TRANSPORT_ADDRESS, *PTRANSPORT_ADDRESS;

//
// define some names for the EAs so people don't have to make them up.
//

#define TdiTransportAddress "TransportAddress"
#define TdiConnectionContext "ConnectionContext"
#define TDI_TRANSPORT_ADDRESS_LENGTH (sizeof (TdiTransportAddress) - 1)
#define TDI_CONNECTION_CONTEXT_LENGTH (sizeof (TdiConnectionContext) - 1)

//
// Known Address types
//

#define TDI_ADDRESS_TYPE_UNSPEC    ((USHORT)0)  // unspecified
#define TDI_ADDRESS_TYPE_UNIX      ((USHORT)1)  // local to host (pipes, portals)
#define TDI_ADDRESS_TYPE_IP        ((USHORT)2)  // internetwork: UDP, TCP, etc.
#define TDI_ADDRESS_TYPE_IMPLINK   ((USHORT)3)  // arpanet imp addresses
#define TDI_ADDRESS_TYPE_PUP       ((USHORT)4)  // pup protocols: e.g. BSP
#define TDI_ADDRESS_TYPE_CHAOS     ((USHORT)5)  // mit CHAOS protocols
#define TDI_ADDRESS_TYPE_NS        ((USHORT)6)  // XEROX NS protocols
#define TDI_ADDRESS_TYPE_IPX       ((USHORT)6)  // Netware IPX
#define TDI_ADDRESS_TYPE_NBS       ((USHORT)7)  // nbs protocols
#define TDI_ADDRESS_TYPE_ECMA      ((USHORT)8)  // european computer manufacturers
#define TDI_ADDRESS_TYPE_DATAKIT   ((USHORT)9)  // datakit protocols
#define TDI_ADDRESS_TYPE_CCITT     ((USHORT)10) // CCITT protocols, X.25 etc
#define TDI_ADDRESS_TYPE_SNA       ((USHORT)11) // IBM SNA
#define TDI_ADDRESS_TYPE_DECnet    ((USHORT)12) // DECnet
#define TDI_ADDRESS_TYPE_DLI       ((USHORT)13) // Direct data link interface
#define TDI_ADDRESS_TYPE_LAT       ((USHORT)14) // LAT
#define TDI_ADDRESS_TYPE_HYLINK    ((USHORT)15) // NSC Hyperchannel
#define TDI_ADDRESS_TYPE_APPLETALK ((USHORT)16) // AppleTalk
#define TDI_ADDRESS_TYPE_NETBIOS   ((USHORT)17) // Netbios Addresses
#define TDI_ADDRESS_TYPE_8022      ((USHORT)18) //
#define TDI_ADDRESS_TYPE_OSI_TSAP  ((USHORT)19) //
#define TDI_ADDRESS_TYPE_NETONE    ((USHORT)20) // for WzMail


//
// Definition of address structures. These need to be packed
// and misaligned where necessary.
//

//#include <packon.h>
// This is packon.h
#if ! (defined(lint) || defined(_lint))
#if ( _MSC_VER >= 800 )
#pragma warning(disable:4103)
#endif
#pragma pack(1)                 // x86, MS compiler; MIPS, MIPS compiler
#endif // ! (defined(lint) || defined(_lint))


//
// NetBIOS
//

typedef struct _TDI_ADDRESS_NETBIOS {
    USHORT NetbiosNameType;
    UCHAR NetbiosName[16];
} TDI_ADDRESS_NETBIOS, *PTDI_ADDRESS_NETBIOS;

#define TDI_ADDRESS_NETBIOS_TYPE_UNIQUE         ((USHORT)0x0000)
#define TDI_ADDRESS_NETBIOS_TYPE_GROUP          ((USHORT)0x0001)
#define TDI_ADDRESS_NETBIOS_TYPE_QUICK_UNIQUE   ((USHORT)0x0002)
#define TDI_ADDRESS_NETBIOS_TYPE_QUICK_GROUP    ((USHORT)0x0003)

#define TDI_ADDRESS_LENGTH_NETBIOS sizeof (TDI_ADDRESS_NETBIOS)
																							 

//
// Xns address for UB
//

typedef struct _TDI_ADDRESS_NETONE {
    USHORT NetoneNameType;
    UCHAR NetoneName[20];
} TDI_ADDRESS_NETONE, *PTDI_ADDRESS_NETONE;

#define TDI_ADDRESS_NETONE_TYPE_UNIQUE  ((USHORT)0x0000)
#define TDI_ADDRESS_NETONE_TYPE_ROTORED ((USHORT)0x0001)

#define TDI_ADDRESS_LENGTH_NETONE sizeof (TDI_ADDRESS_NETONE)


//
// AppleTalk
//

typedef struct _TDI_ADDRESS_APPLETALK {
    USHORT  Network;
    UCHAR   Node;
    UCHAR   Socket;
} TDI_ADDRESS_APPLETALK, *PTDI_ADDRESS_APPLETALK;

#define TDI_ADDRESS_LENGTH_APPLETALK sizeof (TDI_ADDRESS_APPLETALK)


//
// 802.2 MAC addresses
//

typedef struct _TDI_ADDRESS_8022 {
    UCHAR MACAddress[6];
} TDI_ADDRESS_8022, *PTDI_ADDRESS_8022;

#define TDI_ADDRESS_LENGTH_8022  sizeof (TDI_ADDRESS_8022);


//
// IP address
//

typedef struct _TDI_ADDRESS_IP {
    USHORT sin_port;
    ULONG  in_addr;
    UCHAR  sin_zero[8];
} TDI_ADDRESS_IP, *PTDI_ADDRESS_IP;

#define TDI_ADDRESS_LENGTH_IP sizeof (TDI_ADDRESS_IP)


//
// IPX address
//

typedef struct _TDI_ADDRESS_IPX {
    ULONG NetworkAddress;
    UCHAR NodeAddress[6];
    USHORT Socket;
} TDI_ADDRESS_IPX, *PTDI_ADDRESS_IPX;


#define TDI_ADDRESS_LENGTH_IPX sizeof (TDI_ADDRESS_IPX)

//
// XNS address (same as IPX)
//

typedef struct _TDI_ADDRESS_NS {
    ULONG NetworkAddress;
    UCHAR NodeAddress[6];
    USHORT Socket;
} TDI_ADDRESS_NS, *PTDI_ADDRESS_NS;


#define TDI_ADDRESS_LENGTH_NS sizeof (TDI_ADDRESS_NS)

#endif	//_TDI_USER_

// OSI TSAP

/* TDI_ADDRESS_OSI_TSAP
 * The actual structure is
 * {
 *	UCHAR NsapLength;	// Length of NSAP (maximum 20 bytes)
 *	UCHAR Nsap[];		// actually [ NsapLength ]
 *	UCHAR TsapLength;	// Length of TSAP (maximum 32 bytes)
 *	UCHAR Tsap[];		// actually [ TsapLength ]
 * }
 * To prevent structure references like "OsiTsap.TsapLength" which clearly
 * do not work in C, the structure is presented more simply as:-
 */

typedef struct _TDI_ADDRESS_OSI_TSAP {
	UCHAR Tsap[1 + 32 + 1 + 20];
} TDI_ADDRESS_OSI_TSAP, *PTDI_ADDRESS_OSI_TSAP;

#define TDI_ADDRESS_LENGTH_OSI_TSAP sizeof (TDI_ADDRESS_OSI_TSAP)

#ifndef _TDI_USER_

//#include <packoff.h>
// This is all of packoff.h
#if ! (defined(lint) || defined(_lint))
#if ( _MSC_VER >= 800 )
#pragma warning(disable:4103)
#endif
#pragma pack()
#endif // ! (defined(lint) || defined(_lint))


//
// Some pre-defined structures to make life easier for
// the 99.99% of us who use but one address.
//

typedef struct _TA_ADDRESS_NETBIOS {
    int TAAddressCount;
    struct _Addr {
        USHORT AddressLength;       // length in bytes of this address == 18
        USHORT AddressType;         // this will == TDI_ADDRESS_TYPE_NETBIOS
        TDI_ADDRESS_NETBIOS Address[1];
    } Address [1];
} TA_NETBIOS_ADDRESS, *PTA_NETBIOS_ADDRESS;

typedef struct _TA_APPLETALK_ADDR {
    int TAAddressCount;
    struct _AddrAtalk {
        USHORT AddressLength;       // length in bytes of this address == 4
        USHORT AddressType;         // this will == TDI_ADDRESS_TYPE_APPLETALK
        TDI_ADDRESS_APPLETALK   Address[1];
    } Address[1];
} TA_APPLETALK_ADDRESS, *PTA_APPLETALK_ADDRESS;

typedef struct _TA_ADDRESS_IP {
    int TAAddressCount;
    struct _AddrIp {
        USHORT AddressLength;       // length in bytes of this address == 14
        USHORT AddressType;         // this will == TDI_ADDRESS_TYPE_IP
        TDI_ADDRESS_IP Address[1];
    } Address [1];
} TA_IP_ADDRESS, *PTA_IP_ADDRESS;

typedef struct _TA_ADDRESS_IPX {
    int TAAddressCount;
    struct _AddrIpx {
        USHORT AddressLength;       // length in bytes of this address == 12
        USHORT AddressType;         // this will == TDI_ADDRESS_TYPE_IPX
        TDI_ADDRESS_IPX Address[1];
    } Address [1];
} TA_IPX_ADDRESS, *PTA_IPX_ADDRESS;

typedef struct _TA_ADDRESS_NS {
    int TAAddressCount;
    struct _AddrNs {
        USHORT AddressLength;       // length in bytes of this address == 12
        USHORT AddressType;         // this will == TDI_ADDRESS_TYPE_NS
        TDI_ADDRESS_NS Address[1];
    } Address [1];
} TA_NS_ADDRESS, *PTA_NS_ADDRESS;

#endif // _TDI_USER_
#endif //_TDIADDR_H
