/*
 * $Workfile:   winxti.h  $ $Revision:   1.10  $ $Modtime:   20 Jun 1995 11:29:54  $
 *
 * Copyright (c) Boldon James Limited, England.
 *
 * Product		: WinXTI
 * Author		: Ian Parker
 *
 * FILE DESCRIPTION
 *		Header file to be included by WinXTI applications.
 *
 */

#ifndef _WINXTI_H
#define _WINXTI_H

static char WinXTISCCS_id[] = "%W%";

#ifndef _WINDOWS_
#include <windows.h>
#endif /* _WINDOWS_	*/

                  
/*
 * Error Codes
 */
#define TBADADDR		1	/* incorrect addr format */
#define TBADOPT			2	/* incorrect option format */
#define TACCES			3	/* incorrect permissions */
#define TBADF			4	/* illegal transport fd */
#define TNOADDR			5	/* couldn't allocate addr */
#define TOUTSTATE		6	/* out of state */
#define TBADSEQ			7	/* bad call sequence number */
#define TSYSERR			8	/* system error */
#define TLOOK			9	/* event requires attention */
#define TBADDATA		10	/* illegal amount of data */
#define TBUFOVFLW		11	/* buffer not large enough */
#define TFLOW			12	/* flow control */
#define TNODATA			13	/* no data */
#define TNODIS			14	/* discon_ind not found on q */
#define TNOUDERR		15	/* unitdata error not found */
#define TBADFLAG		16	/* bad flag */
#define TNOREL			17	/* no ord rel found on q */
#define TNOTSUPPORT		18	/* primitive not supported */
#define TSTATECHNG		19	/* state is in process of changing */
#define TNOSTRUCTYPE	20	/* unsupported struct-type requested */
#define TBADNAME		21	/* invalid transport provider name */
#define TBADQLEN		22	/* qlen is zero */
#define TADDRBUSY		23	/* address in use */
#define TINDOUT			24	/* outstanding connection indications */
#define TPROVMISMATCH	25	/* transport provider mismatch */
#define TRESQLEN		26	/* resfd to accept with qlen>0 */
#define TRESADDR		27	/* resfd not bound to same addr as fd */
#define TQFULL			28	/* incoming connection queue full */
#define TPROTO			29	/* XTI protocol error */


/*
 * The following are WinXTI specific errors
 */
#define TNOTINIT		40	/* not initialised */
#define WTEINVAL		41	/* invalid parameter */
#define WTEINPROGRESS	42	/* a blocking call is in progress */


/*
 * The following are the events returned
 */
#define	T_LISTEN		0x0001	/* connection indication received */
#define	T_CONNECT		0x0002	/* connect confirmation received */
#define	T_DATA			0x0004	/* normal data received */
#define	T_EXDATA		0x0008	/* expedited data received */
#define	T_DISCONNECT	0x0010	/* disconnect received */
#define	T_ERROR			0x0020	/* fatal error occured */
#define	T_UDERR			0x0040	/* datagram error indication */
#define	T_ORDREL		0x0080	/* orderly release indication */
#define	T_GODATA		0x0100	/* sending normal data is again possible */
#define	T_GOEXDATA		0x0200	/* sending expedited data is again possible */
#define	T_EVENTS		0x03ff	/* event mask */

/*
 * The following are the flag definitions needed by the
 * user level library routines.
 */
#define T_MORE			0x001	/* more data */
#define T_EXPEDITED		0x002	/* expedited data */
#define T_NEGOTIATE		0x004	/* set opts */
#define T_CHECK			0x008	/* check opts */
#define T_DEFAULT		0x010	/* get default opts */
#define T_SUCCESS		0x020	/* successful */
#define T_FAILURE		0x040	/* failure */
#define T_CURRENT		0x080	/* get current options */
#define T_PARTSUCCESS	0x100	/* partial sucess */
#define T_READONLY		0x200	/* read-only */
#define T_NOTSUPPORT	0x400	/* not supported */

/*
 * protocol specific service limits
 */
struct t_info {
	long	addr;		/* size of protocol address */
	long	options;	/* size of protocol options */
	long	tsdu;		/* size of max transport service data unit */
	long	etsdu;		/* size of max expedited tsdu */
	long	connect;	/* max data for connection primitives */
	long	discon;		/* max data for disconnect primitives */
	long	servtype;	/* provider service type */
	long	flags;		/* other info about the transport provider */
};

/*
 * Service type defines
 */
#define T_COTS		01	/* connection oriented transport service */
#define T_COTS_ORD	02	/* connection oriented with orderly release */
#define T_CLTS		03	/* connectionless transport service */

/*
 * Flags defines (other info about the transport provider).
 */
#define T_SENDZERO	0x001	/* supports 0-length TSDUs */

/*
 * netbuf structure
 */
struct netbuf {
	unsigned int	maxlen;
	unsigned int	len;
	char		*buf;
};

/*
 * t_opthdr structure
 */
struct t_opthdr {
	unsigned long len;		/* total length of option,					*/
					        /* i.e. sizeof (struct t_opthdr) + length	*/
					        /* of option value in bytes					*/
	unsigned long level;	/* protocol affected						*/
	unsigned long name;		/* option name								*/
	unsigned long status;	/* status value								*/
				        	/* followed by the option value */
};

/*
 * t_bind - format of the address and options arguments of bind
 */
struct t_bind {
	struct netbuf	addr;
	unsigned		qlen;
};

/*
 * options management
 */
struct t_optmgmt {
	struct netbuf	opt;
	long			flags;
};

/*
 * disconnect structure
 */
struct t_discon {
	struct netbuf	udata;		/* user data */
	int				reason;		/* reason code */
	int				sequence;	/* sequence number */
};

/*
 * call structure
 */
struct t_call {
	struct netbuf	addr;		/* address */
	struct netbuf	opt;		/* options */
	struct netbuf	udata;		/* user data */
	int	            sequence;  	/* sequence number */
};

/*
 * datagram structure
 */
struct t_unitdata {
	struct netbuf	addr;	/* address */
	struct netbuf	opt;	/* options */
	struct netbuf	udata;	/* user data */
};

/*
 * unitdata error structure
 */
struct t_uderr {
	struct netbuf	addr;	/* address */
	struct netbuf	opt;	/* options */
	long	    	error;	/* error code */
};


/*
 * The following are structure types used when dynamically
 * allocating the structures via t_alloc().
 */
#define T_BIND			1	/* struct t_bind */
#define T_OPTMGMT		2	/* struct t_optgmt */
#define T_CALL			3	/* struct t_call */
#define T_DIS			4	/* struct t_discon */
#define T_UNITDATA		5	/* struct t_unitdata */
#define T_UDERROR		6	/* struct t_uderr */
#define T_INFO			7	/* struct t_info */
#define T_POLLFD		8	/* struct t_pollfd */

/*
 * The following bits specify which of the above
 * structures should be allocated by t_alloc().
 */
#define T_ADDR		0x01	/* address */
#define T_OPT		0x02	/* options */
#define T_UDATA		0x04	/* user data */
#define T_ALL		0xffff	/* all the above */

/*
 * The following are the states of the user
 */
#define T_UNBND		1	/* unbound */
#define T_IDLE		2	/* idle */
#define T_OUTCON	3	/* outgoing connection pending */
#define T_INCON		4	/* incoming connection pending */
#define T_DATAXFER	5	/* data transfer */
#define T_OUTREL	6	/* outgoing release pending */
#define T_INREL		7	/* incoming release pending */


/* general purpose defines */

#define T_YES 		1
#define T_NO		0
#define T_UNUSED	-1
#define T_NULL		0
#define T_ABSREQ	0x8000
#define T_INFINITE	-1
#define T_INVALID	-2
/* T_INFINITE AND T_INVALID are values of t_info */

/*
 * General definitions for option management
 */
#define T_UNSPEC	(0 -- 2)  /* applicable to u_long, long, char .. */
#define T_ALLOPT	0
#define T_ALIGN(p)	(((unsigned long) (p) + (sizeof(long) - 1)) \
											(sizeof(long) -- 1))
#define OPT_NEXTHDR(pbuf, buflen, popt) \
			(((char *)(popt) + T_ALIGN((popt)->len < \
			pbuf + buflen) ? \
			(struct t_opthdr *) ((char *)(popt) + T_ALIGN((popt)->len)) : \
			(struct t_opthdr *) NULL)


/* SPECIFIC ISO OPTION AND MANAGEMENT PARAMETERS */

/* definition of ISO transport classes */
#define T_CLASS0	0
#define T_CLASS1	1
#define T_CLASS2	2
#define T_CLASS3	3
#define T_CLASS4	4

/* definition of the priorities */
#define T_PRITOP	0
#define T_PRIHIGH	1
#define T_PRIMID	2
#define T_PRILOW	3
#define T_PRIDFLT	4


/* definition of the protection levels */
#define	T_NOPROTECT			1
#define T_PASSIVEPROTECT	2
#define T_ACTIVEPROTECT		4

/* default value for the length of TPDU's */
#define T_LTPDUDFLT		128

/*
 * rate structure
 */
struct rate {
	long	targetvalue;		/* target value */
	long	minacceptvalue;		/* minimum acceptable value */
};

/*
 * reqvalue structure
 */
struct reqvalue {
	struct rate called;         /* called rate */
	struct rate calling;		/* calling rate */
};

/*
 * thrpt structure
 */
struct thrpt {
	struct reqvalue maxthrpt;	/* maximum throughput */
	struct reqvalue avgthrpt;	/* average throughput */
};

/*
 * transdel structure
 */
struct transdel {
	struct reqvalue	maxdel;		/* maximum transit delay */
	struct reqvalue avgdel;		/* average transit delay */
};

/*
 * management structure
 */
struct management {
	short	dflt;		/* T_YES: the following parameters values are */
                        /* ignored, default value are used */
				        /* T_NO: the following parameters values are used */
	int	    ltpdu;		/* maximum length of TPDU (in octets) */
	short	reastime;	/* reassignment time (in seconds) */
	char	tclass;		/* preferred class; value: T_CLASS0-T_CLASS4 */
	char	altclass;	/* alternative class */
	char	extform;	/* extended format: T_YES or T_NO */
	char	flowctrl;	/* flow control T_YES or T_NO */
	char	checksum;	/* checksum(cl.4): T_YES or T_NO */
	char	netexp;		/* network expedited data: T_YES or T_NO */
	char	netrecptcf;	/* receipt confirmation: T_YES or T_NO */
};

/*
 *	ISO connection oriented options
 */
struct isoco_options {
	struct	thrpt		throughput;	    /* throughput */
	struct	reqvalue	transdel;	    /* transit delay */
	struct	rate		reserrorrate;	/* residual error rate */
	struct	rate		transffailprob;	/* transfer error prob. */
	struct	rate		estfailprob;	/* connection establ. failure prob. */
	struct	rate		relfailprob;	/* connection release failure prob. */
	struct	rate		estdelay;	    /* connection establishment delay */
	struct	rate		reldelay;	    /* connection release delay */
	struct	netbuf		connresil;	    /* connection resilience */
	short	            protection;		/* protection */
	short	            priority;		/* priority */
	struct  management	mngmt;		    /* management parameters */
	char	            expd;			/* expedited data: T_YES or T_NO */
};

/*
 *	ISO connectionless options
 */
struct isocl_options {
	struct rate		transdel;		/* transit delay */
	struct rate		reserrorrate;	/* residual error rate */
	unsigned short	protection;		/* protection */
	short			priority;		/* priority */
};

	/* TCP SPECIFIC ENVIRONMENT */


/*
 *	TCP precedence levels
 */
#define T_ROUTINE			0
#define T_PRIORITY			1
#define T_IMMEDIATE			2
#define T_FLASH				3
#define T_OVERRIDEFLASH		4
#define T_CRITIC_ECP		5
#define T_INETCONTROL		6
#define T_NETCONTROL		7

/*
 *	TCP security options structure
 */
struct secoptions {
	short	security;		/* security field */
	short	compartment;	/* compartment */
	short	handling;		/* handling restrictions */
	long	tcc;			/* transmission control code */
};

/*
 *	TCP options
 */
struct tcp_options {
	short	precedence;				/* precedence */
	long	timeout;				/* abort timeout */
	long	max_seg_size;			/* maximum segment size */
	struct	secoptions	secopt;		/* TCP security options */
};

/*
 *	pollfd structure
 */
 struct t_pollfd	{
	HANDLE	fd;	 		/* Endpoint to poll */
	short	events;		/* events of interest on fd */
	short	revents;	/* events that occurred on fd */
};	   

/*
 * Testable select events
 */
#define	POLLIN		0x0001		/* fd is readable */
#define	POLLPRI		0x0002		/* high priority info at fd */
#define	POLLOUT		0x0004		/* fd is writeable (won't block) */
#define	POLLRDNORM	0x0040		/* normal data is readable */
#define	POLLWRNORM	POLLOUT
#define	POLLRDBAND	0x0080		/* out-of-band data is readable */
#define	POLLWRBAND	0x0100		/* out-of-band data is writeable */

#define	POLLNORM	POLLRDNORM

/*
 * Non-testable poll events (may not be specified in events field,
 * but may be returned in revents field).
 */
#define	POLLERR		0x0008		/* fd has error condition */
#define	POLLHUP		0x0010		/* fd has been hung up on */
#define	POLLNVAL	0x0020		/* invalid pollfd entry */


/*
 *	WXTIData structure
 */
#define  WXDESCRIPTION_LENGTH	256
 struct WXTIData {
	WORD	wVersion;		/* The version of the WinXTI	  */
				            /* specification that the WinXTI  */
					        /* DLL expects the caller to use. */
	WORD	wHighVersion;	/* Highest version this WinXTI DLL supports */
	char	szDescription[WXDESCRIPTION_LENGTH+1];	/* Vendor info string */
	USHORT	iMaxTEPs;		/* maximum endpoints WinXTI can open */
};

/*
 * WinXTI error returns
 */
#define		WXTI_ERROR		(-1)
#define 	INVALID_TEP		(0xFFFFFFFF)

/*
 * WinXTI structures allocated using WtAlloc()
 */
#define T_STATS		 1

/*
 *	 fcntl commands
 */
#include <fcntl.h>
/*
 * Flags for opening a WinXTI endpoint (oflags on a t_open).
 * 1.  O_RDWR only - Blocking mode, multi-threaded in NT device
 *     IO manager. End-point handle is overlapped so ReadFile() and WriteFile()
 *     require an overlapped structure and will not block.
 * 2.  O_NDELAY - Non-blocking mode. Endpoint handle is overlapped, hence
 *     ReadFile() and WriteFile() operate in overlapped mode.
 * 3.  O_SINGLE_THREAD - Blocking mode, single threaded in NT device IO mngr.
 *     NOT to be used with multiple threads on the same endpoint.
 *     Only use if the endpoint handle MUST be non-overlapped and hence
 *     ReadFile() and WriteFile() will block.
*/

/*#define	O_RDWR			2 (defined in fcntl.h)	*/
#define		O_NONBLOCK              0x80
#define		O_SINGLE_THREAD			0x8800
#define		F_SETFL			        01
#define		F_GETFL                 02
	
/*
 * WinXTI Typedefs
 */
typedef HANDLE	TEP;

#ifndef WXTI_EXPORT
#define DllImport __declspec( dllimport )

/*
 * Applications using WinXTI must include the following imports.
 */
#if defined(__cplusplus)
extern "C" {
#endif

extern DllImport int	WINAPI	t_accept(TEP, TEP, struct t_call FAR *);
extern DllImport char*	WINAPI	t_alloc(TEP, int, int);
extern DllImport int	WINAPI	t_bind(TEP, struct t_bind FAR *, struct t_bind FAR *);
extern DllImport int	WINAPI	t_close(TEP);
extern DllImport int	WINAPI	t_connect(TEP, struct t_call FAR *, struct t_call FAR *);
extern DllImport int	WINAPI	t_error(const char FAR *);
extern DllImport int	WINAPI	t_free(char FAR *, int FAR);
extern DllImport int	WINAPI	t_getinfo(TEP, struct t_info *);
extern DllImport int	WINAPI	t_getprotaddr(TEP, struct t_bind FAR *, struct t_bind FAR *);
extern DllImport int	WINAPI	t_getstate(TEP);
extern DllImport int	WINAPI	t_listen(TEP, struct t_call *);
extern DllImport int	WINAPI	t_look(TEP);
extern DllImport TEP	WINAPI	t_open(char FAR *, int, struct t_info FAR *);
extern DllImport int	WINAPI	t_optmgmt(TEP, struct t_optmgmt FAR *, struct t_optmgmt FAR *);
extern DllImport int	WINAPI	t_rcv(TEP, char FAR *, unsigned int, int FAR *);
extern DllImport int	WINAPI	t_rcvconnect(TEP, struct t_call FAR *);
extern DllImport int	WINAPI	t_rcvdis(TEP, struct t_discon FAR *);
extern DllImport int	WINAPI	t_rcvrel(TEP);
extern DllImport int	WINAPI	t_rcvudata(TEP, struct t_unitdata FAR *, int FAR *);
extern DllImport int	WINAPI	t_rcvuderr(TEP, struct t_uderr FAR *);
extern DllImport int	WINAPI	t_snd(TEP, const char FAR *, unsigned int, int);
extern DllImport int	WINAPI	t_snddis(TEP, struct t_call FAR *);
extern DllImport int	WINAPI	t_sndrel(TEP);
extern DllImport int	WINAPI	t_sndudata(TEP, struct t_unitdata FAR *);
extern DllImport char*	WINAPI	t_strerror(int);
extern DllImport int	WINAPI	t_sync(TEP);
extern DllImport int	WINAPI	t_unbind(TEP);

extern DllImport int	WINAPI	WtCloseHandles(TEP);
extern DllImport int	WINAPI	WtAsyncPoll(TEP, HWND, unsigned int, long);
extern DllImport int	WINAPI	WtCancel(TEP);
extern DllImport int	WINAPI	WtCleanup(void);
extern DllImport int	WINAPI	WtGetLastError(void);
extern DllImport void	WINAPI	WtSetLastError(int);
extern DllImport int	WINAPI	WtGetLastTerror(void);
extern DllImport BOOL	WINAPI	WtSetLastTerror(int);
extern DllImport int	WINAPI	WtGetStats(TEP,  void *);
extern DllImport char*	WINAPI	WtAlloc(TEP, int);
extern DllImport int	WINAPI	WtFree(char *, int);
extern DllImport int	WINAPI	WtFcntl(TEP, long, unsigned long *);
extern DllImport int	WINAPI	WtIsBlocking(TEP);
extern DllImport int	WINAPI	WtPoll(struct t_pollfd FAR [], unsigned long, int);
extern DllImport FARPROC WINAPI	WtSetBlockingHook(FARPROC);
extern DllImport int	WINAPI	WtStartup(WORD, struct WXTIData FAR *);
extern DllImport int	WINAPI	WtUnhookBlockingHook(void);

#ifndef _WINSOCKAPI_
// Network to host byte ordering routines.
extern DllImport USHORT WINAPI	htons(USHORT);
extern DllImport USHORT WINAPI	ntohs(USHORT);
extern DllImport ULONG WINAPI	htonl(ULONG);
extern DllImport ULONG WINAPI	ntohl(ULONG);		
extern DllImport ULONG WINAPI	inet_addr(const char*);

struct in_addr {
        union {
                struct { UCHAR s_b1,s_b2,s_b3,s_b4; } S_un_b;
                struct { UCHAR s_w1,s_w2; } S_un_w;
                ULONG S_addr;
        } S_un;
#define s_addr  S_un.S_addr     	/* can be used for most tcp & ip code */
#define s_host  S_un.S_un_b.s_b2  	/* host on imp */
#define s_net   S_un.S_un_b.s_b1   	/* network */
#define s_imp   S_un.S_un_w.s_w2   	/* imp */
#define s_impno S_un.S_un_b.s_b4   	/* imp # */
#define s_lh    S_un.S_un_b.s_b3    /* logical host */
};

extern DllImport char * WINAPI inet_ntoa(const struct in_addr);		
#endif

#define WXGETPOLLERROR(lParam)	HIWORD(lParam)
#define	WXGETPOLLEVENT(lParam)	LOWORD(lParam)

#if defined(__cplusplus)
}
#endif

#endif /* WXTI_EXPORT */
#endif /* _WINXTI_H */
