#pragma comment ( exestr, "$Workfile: bjlog.h $ $Revision: 29 $ $Modtime: 10-03-98 5:17p $")
/*
 * Copyright (c) Boldon James Limited, England.
 *
 * Product:    Windows NT
 * Module:
 * Version:    Base
 *
 * FILE DESCRIPTION
 *
 * MODIFICATION HISTORY
 *
 * $Log: /_IMPART_V5/_IMPART-X/Pictor/PictorManager/bjlog.h $
// 
// 29    10-03-98 5:51p Ianp
// 
// 28    10-09-97 6:21p Ianp
// Added "return TRUE" to BJLOGTERMINAT macro for _NOBJLOGGING
// 
// 26    13/05/97 17:24 Steven
// Added BJLOGUSERINFO_7 macros
// 
// 25    13/05/97 14:55 Steven
// Return TRUE for the BJLOGINITIALISE macro when called with _NOBJLOGGING
// set
//
//24    5/07/97 12:02p Mick
//Stop using STRTYPE
// 
// 23    17/04/97 15:13 Steven
// 1. Added BJLOGUSERERROR_5 macro.
// 2. BJLOGINPUT macro was missing a final ']' so this was added
// 
// 22    17/04/97 9:52 Steven
// Added BJLOGUSERINFO_6 macro
//
//21    4/16/97 4:25p Mick
//
//20    4/16/97 11:52a Mick
//Add extra macros to assist in user-level logging and use TYPE_USER for
//such messages
//
//19    4/11/97 5:18p Mick
//extra logging in BJLOGINITIALISE macro
//
//18    4/11/97 3:24p Mick
//Add common code to BJLOGINITIALSE macro
//
//16    4/10/97 3:40p Mick
//add more macros
//
//15    4/10/97 2:12p Mick
//
//12    4/10/97 10:32a Mick
//Add new BJLOGINFO macros for logging user tracing on behalf of the
//controls.
//
//Change the flag that results in the logging macros generating nothing
//to _NOBJLOGGING
// 
// 8     21/02/97 11:46 Ianp
// 
// 7     23/01/97 16:41 Ianp
// Added comments to 
// 
// 6     15/01/97 17:26 Steven
// Added DEBUGLOG... macros that get defined out of release builds
// Added more BJLOG... type macros
 * 
 *    Rev 1.6   28 Jun 1995 15:58:58   BOB
 * BJCopy...() functions added.
 * 
 *    Rev 1.5   22 Nov 1994 14:01:56   BOB
 * Extra param added to BJLogChange.
 * 
 *    Rev 1.4   21 Nov 1994 15:38:44   DLOWNDES
 * Added the EXPORTFN macro to eliminate in-line #ifdef's when declaring the
 * WINAPIV functions.
 *
 *    Rev 1.3   18 Nov 1994 15:27:34   KATHM
 * Added defines
 *
 *    Rev 1.2   16 Nov 1994 12:03:58   DLOWNDES
 * Added a defn for WINAPIV (which doesn't exist under 16 bit Windows headers)
 *
 *    Rev 1.1   16 Nov 1994 11:21:24   BOB
 * Functions now WINAPI(V).
 *
 *    Rev 1.0   09 Nov 1994 13:50:52   KATHM
 * Initial_Revision
 *
 *    Rev 1.0   07 Nov 1994 16:40:24   KATHM
 * Initial_Revision
 *
 *    Rev 1.0   07 Nov 1994 16:36:10   KATHM
 * Initial_Revision
 *
 *
 *
 */

// Message type values	

// Logging level
#define NOLOGGING	0x0000
#define FATAL		0x0001
#define NONFATAL	0x0002
#define WARNING		0x0003
#define INFO		0x0004
#define LEVEL1		0x0005
#define LEVEL2		0x0006
#define LEVEL3		0x0007
#define LEVEL4		0x0008
#define LEVEL5		0x0009
#define LEVEL6		0x000A
#define LEVEL7		0x000B
#define LEVEL8		0x000C
#define LEVEL9		0x000D
#define LEVEL10		0x000E
#define LEVEL11		0x000F

/* definitions for types of errors */
#define	TYPE_ERROR		0x0010
#define	TYPE_TRACE		0x0020
#define	TYPE_DIAG		0x0030
#define TYPE_USER		0x0040
#define TYPE_PROGRAM	0x0050
#define TYPE_SYSTEM		0x0060
#define TYPE_NETWORK	0x0070
#define TYPE_WARN		0x0080
#define TYPE_INFO		0x0090

/* format for output of errors when validating diagnostics section of .ini file or registry */
#define	NONE		0x00	// don't report validation errors
#define	MSGBOX		0x01	// report errors in a message box
#define	LOG			0x02	// report errors in the logfile

/* format for diagnostic output */
#define	BJD_HEX		1	// hex characters
#define	BJD_ASCII	2	// ascii characters
#define	BJD_COMBI	3	// hex and ascii	
#define	BJD_SCRIPT	4	// not yet implemented, intended to create simulator script format

/* masks for informaton in message type parameter */
#define TRACELEVEL	0x000F
#define TYPEMSG		0x00F0

#define NTEVENT		0x0100	// Output to NT event log
#define BJEVENT		0x0200	// Not used - Intended for a BJ event logger.
#define DISPMSGBOX	0x0400	// Message displayed in a message box

#define STRTYPE		0x0800	// Uses FormatMessage with FORMAT_MESSAGE_FROM_HMODULE
							//   string format passed as resource ID, normally in impart.dll.
#define FMTTYPE		0x1000	// Uses FormatMessage with FORMAT_MESSAGE_FROM_STRING
							//   string format passed as string parameter.
							//   USE THIS IF YOUR OUTPUT MESSAGE MAY BE > 512 bytes long.


#ifndef WIN32
#define WINAPIV FAR CDECL
#endif

//GLOBAL FUNCTIONS							*
#ifdef WIN32
#define EXPORTFN( Type ) __declspec(dllexport) Type
#else
#define EXPORTFN( Type ) Type __export
#endif

#ifdef __cplusplus
extern "C" {
#endif

// Win32 functions 

// Initialise logging. Must be called before any other logging calls.
// if the registry entry does not exist, it is created.
// If already initialised this does nothing!
BOOL WINAPI  BJLogInitialise(LPCSTR lpAppId,	// the application name
							 LPCSTR loc,		// registry key OR .INI file pathname
							 LPCSTR sect,		// registry diagnostics OR .INI file section
							 BOOL Reg);			// TRUE if using the registry

// As BJLogInitialise(), re-initialise based on supplied registry or ini locations.
BOOL WINAPI   BJLogChange	(LPCSTR lpAppId, LPCSTR loc, LPCSTR sect, BOOL Reg) ;

// Re-reads the supplied ini file and re-sets logging values.
BOOL WINAPI   BJLogReadIni	(LPCSTR lpAppId, LPCSTR loc, LPCSTR sect, BOOL Reg) ;

// Terminate logging
BOOL WINAPI   BJLogTerminate (void) ;

// Log a printf style message 
EXPORTFN( BOOL WINAPIV ) BJLogMessage(LPCSTR lpAppId,		// app name 
									  LPCSTR lpFile,		// source file __FILE__
									  WORD wLineNo,			// source line __LINE__
									  WORD wMsgType,		// message level & type bitmask
									  LPCSTR lpErrorStr,	// printf style format string
									  ...);					// format arguments ...

// As BJLogMessage but also passes a buffer, lphCopyBuff to receive a copy of the
// formatted log message.
EXPORTFN( BOOL WINAPIV ) BJCopyLogMessage(LPCSTR lpAppId,
										  LPCSTR lpFile,
										  WORD wLineNo,
										  WORD wMsgType,
										  HGLOBAL far *lphCopyBuff,
										  LPCSTR lpErrorStr,
										  ...);

// As BJLogMessage but also logs data passed in lpMem to:
// 1. NT Event log if NTEVENT set in wMsgType.
// 2. if (Level > LEVEL5) BJlog window and file formatted as BJD_HEX etc  
EXPORTFN( BOOL WINAPIV ) BJLogDiag(LPCSTR lpAppId,		// app name 
								   LPCSTR lpFile,		// source file __FILE__
								   WORD wLineNo,		// source line __LINE__
								   LPVOID lpMem,		// length of mem to be displayed
								   WORD wMemLen,		// memory for dispay
								   WORD wFormat,		// memory display format, BJD_HEX etc
								   WORD wMsgType,		// message level & type bitmask
								   LPCSTR lpErrorStr,	// printf style format string
								   ...);				// format arguments ...

// Return logging level value for the application
EXPORTFN( WORD WINAPIV ) BJLogGetLoggingLevel (LPCSTR lpAppId);

// Toggle between current logging level and old logging level
EXPORTFN( WORD WINAPIV ) BJLogToggleLoggingLevel (LPCSTR lpAppId);

// Set a new logging level, saves curren in old logging level.
EXPORTFN( WORD WINAPIV ) BJLogSetLoggingLevel (LPCSTR lpAppId, WORD wNewLevel);

// Re-read registry or ini file settings.
EXPORTFN( BOOL WINAPIV ) BJLogReInitialise (LPCSTR lpAppId);

// As BJLogMessage but appends system error message for uError, displays a message box
// if bMsgBox is true;
EXPORTFN( BOOL WINAPIV ) BJLogErrorNo (LPCSTR lpAppId, LPCSTR lpFile, WORD wLineNo,
			WORD wMsgType, LPCSTR lpMsg, UINT uError, BOOL bMsgBox);

#ifdef __cplusplus
}
#endif

#define BJLOG_ID 	"BJLog"

#ifdef WIN32

//
// BJLog macros
//
// These macros enable us to suppress all logging (and the need for the DLLs and
// registry entries) in "slim" versions of our code.
// Where a macro ends in _X, it signifies the macro takes 'X' parameters
// 
// The macros BJLOGUSERx are supplied for use by ActiveX controls and
// automation servers.  They log messages without the "level" prefix to 
// avoid confusing users
//
// The macro BJLOGUSERINFO is also provided for such users and whether
// it logs or not is controlled by setting the INFO option for the user's
// application in the registry by using IMPTRACE
//
#ifndef _NOBJLOGGING

#define BJLOGINITIALISE(lpAppId) \
		{char tmppath[MAX_PATH]; \
		char tmpnam[100]; \
		lstrcpy(tmppath, "SOFTWARE\\Boldon James\\"); \
		if ((lpAppId == NULL) || (*lpAppId == 0)) \
			lstrcpy(tmpnam,"ANONYMOUS"); \
		else \
			lstrcpy(tmpnam,lpAppId); \
		lstrcat(tmppath, tmpnam); \
		return BJLogInitialise(tmpnam, tmppath, "Diagnostics", TRUE);}	
#define BJLOGTERMINATE()	return BJLogTerminate ();
#define BJLOGFATAL_1(a)		BJLogMessage(BJ_APP, __FILE__, __LINE__, FATAL|TYPE_ERROR, a)
#define BJLOGFATAL_2(a, b)	BJLogMessage(BJ_APP, __FILE__, __LINE__, FATAL|TYPE_ERROR, a, b)
#define BJLOGFATAL_3(a, b, c)	BJLogMessage(BJ_APP, __FILE__, __LINE__, FATAL|TYPE_ERROR, a, b, c)
#define BJLOGERROR(msg)		BJLogMessage(BJ_APP, __FILE__, __LINE__, TYPE_ERROR|NONFATAL, msg)
#define BJLOGERROR_1(a)		BJLogMessage(BJ_APP, __FILE__, __LINE__, TYPE_ERROR|NONFATAL, a)
#define BJLOGERROR_2(a,b)	BJLogMessage(BJ_APP, __FILE__, __LINE__, TYPE_ERROR|NONFATAL, a, b)
#define BJLOGERROR_3(a,b,c)	BJLogMessage(BJ_APP, __FILE__, __LINE__, TYPE_ERROR|NONFATAL, a, b, c)
#define BJLOGERROR_4(a,b,c,d)	BJLogMessage(BJ_APP, __FILE__, __LINE__, TYPE_ERROR|NONFATAL, a, b, c, d)

// BJLOGUSERERROR - this is used only for produceing user-level tracing messages
// to assist the user in debugging their applications when using our toolkits
#define BJLOGUSERERROR(msg)		BJLogMessage(BJ_APP, __FILE__, __LINE__, TYPE_ERROR|INFO, msg)
#define BJLOGUSERERROR_1(a)		BJLogMessage(BJ_APP, __FILE__, __LINE__, TYPE_ERROR|INFO, a)
#define BJLOGUSERERROR_2(a,b)	BJLogMessage(BJ_APP, __FILE__, __LINE__, TYPE_ERROR|INFO, a, b)
#define BJLOGUSERERROR_3(a,b,c)	BJLogMessage(BJ_APP, __FILE__, __LINE__, TYPE_ERROR|INFO, a, b, c)
#define BJLOGUSERERROR_4(a,b,c,d)	BJLogMessage(BJ_APP, __FILE__, __LINE__, TYPE_ERROR|INFO, a, b, c, d)
#define BJLOGUSERERROR_5(a,b,c,d,e)	BJLogMessage(BJ_APP, __FILE__, __LINE__, TYPE_ERROR|INFO, a, b, c, d, e)

#define BJLOGWARNING_1(a)		BJLogMessage(BJ_APP, __FILE__, __LINE__, WARNING|TYPE_WARN, a)
#define BJLOGWARNING_2(a, b)		BJLogMessage(BJ_APP, __FILE__, __LINE__, WARNING|TYPE_WARN, a, b)
#define BJLOGWARNING_3(a, b, c)	BJLogMessage(BJ_APP, __FILE__, __LINE__, WARNING|TYPE_WARN, a, b, c)
// BJLOGUSERWARN - this is used only for produceing user-level tracing messages
// to assist the user in debugging their applications when using our toolkits
#define BJLOGUSERWARNING_1(a)		BJLogMessage(BJ_APP, __FILE__, __LINE__, INFO|TYPE_WARN, a)
#define BJLOGUSERWARNING_2(a, b)		BJLogMessage(BJ_APP, __FILE__, __LINE__, INFO|TYPE_WARN, a, b)
#define BJLOGUSERWARNING_3(a, b, c)	BJLogMessage(BJ_APP, __FILE__, __LINE__, INFO|TYPE_WARN, a, b, c)
// BJLOGINFO - this is used only for produceing user-level tracing messages
// to assist the user in debugging their applications when using our toolkits
// BJLOGUSERINFO is PREFERRED
#define BJLOGINFO(msg)		BJLogMessage(BJ_APP, __FILE__, __LINE__, TYPE_USER|INFO, msg)
#define BJLOGINFO_1(a)		BJLogMessage(BJ_APP, __FILE__, __LINE__, TYPE_USER|INFO, a)
#define BJLOGINFO_2(a,b)	BJLogMessage(BJ_APP, __FILE__, __LINE__, TYPE_USER|INFO, a, b)
#define BJLOGINFO_3(a,b,c)	BJLogMessage(BJ_APP, __FILE__, __LINE__, TYPE_USER|INFO, a, b, c)
#define BJLOGINFO_4(a,b,c,d) BJLogMessage(BJ_APP, __FILE__, __LINE__, TYPE_USER|INFO, a, b, c, d)
// BJLOGUSERINFO - is used only for produceing user-level tracing messages
// to assist the user in debugging their applications when using our toolkits
#define BJLOGUSERINFO_1(a)		BJLogMessage(BJ_APP, __FILE__, __LINE__, TYPE_USER|INFO, a)
#define BJLOGUSERINFO_2(a,b)	BJLogMessage(BJ_APP, __FILE__, __LINE__, TYPE_USER|INFO, a, b)
#define BJLOGUSERINFO_3(a,b,c)	BJLogMessage(BJ_APP, __FILE__, __LINE__, TYPE_USER|INFO, a, b, c)
#define BJLOGUSERINFO_4(a,b,c,d) BJLogMessage(BJ_APP, __FILE__, __LINE__, TYPE_USER|INFO, a, b, c, d)
#define BJLOGUSERINFO_5(a,b,c,d,e) BJLogMessage(BJ_APP, __FILE__, __LINE__, TYPE_USER|INFO, a, b, c, d, e)
#define BJLOGUSERINFO_6(a,b,c,d,e,f) BJLogMessage(BJ_APP, __FILE__, __LINE__, TYPE_USER|INFO, a, b, c, d, e, f)
#define BJLOGUSERINFO_7(a,b,c,d,e,f,g) BJLogMessage(BJ_APP, __FILE__, __LINE__, TYPE_USER|INFO, a, b, c, d, e, f, g)

#define BJLOGTRACE(msg)		BJLogMessage(BJ_APP, __FILE__, __LINE__, TYPE_TRACE|LEVEL1, msg)
#define BJLOGTRACE_1(a)		BJLogMessage(BJ_APP, __FILE__, __LINE__, TYPE_TRACE|LEVEL1, a)
#define BJLOGTRACE_2(a,b)	BJLogMessage(BJ_APP, __FILE__, __LINE__, TYPE_TRACE|LEVEL1, a, b)
#define BJLOGTRACE_3(a,b,c)	BJLogMessage(BJ_APP, __FILE__, __LINE__, TYPE_TRACE|LEVEL1, a, b, c)
#define BJLOGDATA(data, len, msg) BJLogDiag(BJ_APP, __FILE__, __LINE__, (LPVOID)data, (WORD)len, \
				BJD_COMBI, TYPE_DIAG|LEVEL6, msg)
#define BJLOGDIAG(msg)		BJLogMessage(BJ_APP, __FILE__, __LINE__, TYPE_TRACE|LEVEL5, msg)
#define BJLOGDIAG_1(a)		BJLogMessage(BJ_APP, __FILE__, __LINE__, TYPE_TRACE|LEVEL5, a)
#define BJLOGDIAG_2(a,b)	BJLogMessage(BJ_APP, __FILE__, __LINE__, TYPE_TRACE|LEVEL5, a, b)
#define BJLOGDIAG_3(a,b,c)	BJLogMessage(BJ_APP, __FILE__, __LINE__, TYPE_TRACE|LEVEL5, a, b, c)
#define BJLOGOUTPUT(buff, len)  BJLogDiag(BJ_APP, __FILE__, __LINE__, (LPVOID)buff, (WORD)len, BJD_COMBI, \
				TYPE_TRACE|LEVEL4, "Output data (%d bytes):", len)
#define BJLOGINPUT(buff, len)  BJLogDiag(BJ_APP, __FILE__, __LINE__, (LPVOID)buff, (WORD)len, BJD_COMBI, \
				TYPE_TRACE|LEVEL4, "Input data (%d bytes):", len)
#define BJLOGLEVEL1_1(a)		BJLogMessage(BJ_APP, __FILE__, __LINE__, LEVEL1|TYPE_DIAG, a)
#define BJLOGLEVEL1_2(a,b)	BJLogMessage(BJ_APP, __FILE__, __LINE__, LEVEL1|TYPE_DIAG, a, b)
#define BJLOGLEVEL1_3(a,b,c)	BJLogMessage(BJ_APP, __FILE__, __LINE__, LEVEL1|TYPE_DIAG, a, b, c)

#define BJLOGLEVEL2_1(a)		BJLogMessage(BJ_APP, __FILE__, __LINE__, LEVEL2|TYPE_DIAG, a)
#define BJLOGLEVEL2_2(a,b)	BJLogMessage(BJ_APP, __FILE__, __LINE__, LEVEL2|TYPE_DIAG, a, b)
#define BJLOGLEVEL2_3(a,b,c)	BJLogMessage(BJ_APP, __FILE__, __LINE__, LEVEL2|TYPE_DIAG, a, b, c)

#define BJLOGLEVEL3_1(a)		BJLogMessage(BJ_APP, __FILE__, __LINE__, LEVEL3|TYPE_DIAG, a)
#define BJLOGLEVEL3_2(a,b)	BJLogMessage(BJ_APP, __FILE__, __LINE__, LEVEL3|TYPE_DIAG, a, b)
#define BJLOGLEVEL3_3(a,b,c)	BJLogMessage(BJ_APP, __FILE__, __LINE__, LEVEL3|TYPE_DIAG, a, b, c)

#define BJLOGLEVEL4_1(a)		BJLogMessage(BJ_APP, __FILE__, __LINE__, LEVEL4|TYPE_DIAG, a)
#define BJLOGLEVEL4_2(a,b)	BJLogMessage(BJ_APP, __FILE__, __LINE__, LEVEL4|TYPE_DIAG, a, b)
#define BJLOGLEVEL4_3(a,b,c)	BJLogMessage(BJ_APP, __FILE__, __LINE__, LEVEL4|TYPE_DIAG, a, b, c)

#define BJLOGLEVEL5_1(a)		BJLogMessage(BJ_APP, __FILE__, __LINE__, LEVEL5|TYPE_DIAG, a)
#define BJLOGLEVEL5_2(a,b)	BJLogMessage(BJ_APP, __FILE__, __LINE__, LEVEL5|TYPE_DIAG, a, b)
#define BJLOGLEVEL5_3(a,b,c)	BJLogMessage(BJ_APP, __FILE__, __LINE__, LEVEL5|TYPE_DIAG, a, b, c)
#define BJLOGLEVEL5_4(a,b,c,d)	BJLogMessage(BJ_APP, __FILE__, __LINE__, LEVEL5|TYPE_DIAG, a, b, c, d)
#define BJLOGLEVEL5_5(a,b,c,d,e )	BJLogMessage(BJ_APP, __FILE__, __LINE__, LEVEL5|TYPE_DIAG, a, b, c, d, e)

#define BJLOGLEVEL6_1(a)		BJLogMessage(BJ_APP, __FILE__, __LINE__, LEVEL6|TYPE_DIAG, a)
#define BJLOGLEVEL6_2(a,b)	BJLogMessage(BJ_APP, __FILE__, __LINE__, LEVEL6|TYPE_DIAG, a, b)
#define BJLOGLEVEL6_3(a,b,c)	BJLogMessage(BJ_APP, __FILE__, __LINE__, LEVEL6|TYPE_DIAG, a, b, c)

#define BJLOGLEVEL7_1(a)		BJLogMessage(BJ_APP, __FILE__, __LINE__, LEVEL7|TYPE_DIAG, a)
#define BJLOGLEVEL7_2(a,b)	BJLogMessage(BJ_APP, __FILE__, __LINE__, LEVEL7|TYPE_DIAG, a, b)
#define BJLOGLEVEL7_3(a,b,c)	BJLogMessage(BJ_APP, __FILE__, __LINE__, LEVEL7|TYPE_DIAG, a, b, c)

#define BJLOGLEVEL8_1(a)		BJLogMessage(BJ_APP, __FILE__, __LINE__, LEVEL8|TYPE_DIAG, a)
#define BJLOGLEVEL8_2(a,b)	BJLogMessage(BJ_APP, __FILE__, __LINE__, LEVEL8|TYPE_DIAG, a, b)
#define BJLOGLEVEL8_3(a,b,c)	BJLogMessage(BJ_APP, __FILE__, __LINE__, LEVEL8|TYPE_DIAG, a, b, c)

#define BJLOGLEVEL9_1(a)		BJLogMessage(BJ_APP, __FILE__, __LINE__, LEVEL9|TYPE_DIAG, a)
#define BJLOGLEVEL9_2(a,b)	BJLogMessage(BJ_APP, __FILE__, __LINE__, LEVEL9|TYPE_DIAG, a, b)
#define BJLOGLEVEL9_3(a,b,c)	BJLogMessage(BJ_APP, __FILE__, __LINE__, LEVEL9|TYPE_DIAG, a, b, c)

#define BJLOGLEVEL10_1(a)	BJLogMessage(BJ_APP, __FILE__, __LINE__, LEVEL10|TYPE_DIAG, a)
#define BJLOGLEVEL10_2(a,b)	BJLogMessage(BJ_APP, __FILE__, __LINE__, LEVEL10|TYPE_DIAG, a, b)
#define BJLOGLEVEL10_3(a,b,c) BJLogMessage(BJ_APP, __FILE__, __LINE__, LEVEL10|TYPE_DIAG, a, b, c)

#define BJLOGLEVEL11_1(a)	 BJLogMessage(BJ_APP, __FILE__, __LINE__, LEVEL11|TYPE_DIAG, a)
#define BJLOGLEVEL11_2(a,b)	 BJLogMessage(BJ_APP, __FILE__, __LINE__, LEVEL11|TYPE_DIAG, a, b)
#define BJLOGLEVEL11_3(a,b,c) BJLogMessage(BJ_APP, __FILE__, __LINE__, LEVEL11|TYPE_DIAG, a, b, c)

#else //_NOBJLOGGING

#define BJLOGINITIALISE(lpAppId) { return TRUE; }
#define BJLOGTERMINATE()		 { return TRUE; }

#define BJLOGFATAL_1(a)
#define BJLOGFATAL_2(a,b)	
#define BJLOGFATAL_3(a,b,c)	
#define BJLOGERROR(msg)	
#define BJLOGERROR_1(a)		
#define BJLOGERROR_2(a,b)
#define BJLOGERROR_3(a,b,c)	
#define BJLOGERROR_4(a,b,c,d)
#define BJLOGUSERERROR(msg)	
#define BJLOGUSERERROR_1(a)		
#define BJLOGUSERERROR_2(a,b)
#define BJLOGUSERERROR_3(a,b,c)	
#define BJLOGUSERERROR_4(a,b,c,d)
#define BJLOGUSERERROR_5(a,b,c,d,e)
#define BJLOGWARNING_1(a)
#define BJLOGWARNING_2(a,b)
#define BJLOGWARNING_3(a,b,c)
#define BJLOGUSERWARNING_1(a)
#define BJLOGUSERWARNING_2(a,b)
#define BJLOGUSERWARNING_3(a,b,c)
#define BJLOGINFO(msg)
#define BJLOGINFO_1(a)
#define BJLOGINFO_2(a,b)	
#define BJLOGINFO_3(a,b,c)
#define BJLOGINFO_4(a,b,c,d)
#define BJLOGINFO_5(a,b,c,d,e)
#define BJLOGINFO(msg)
#define BJLOGUSERINFO_1(a)
#define BJLOGUSERINFO_2(a,b)	
#define BJLOGUSERINFO_3(a,b,c)
#define BJLOGUSERINFO_4(a,b,c,d)
#define BJLOGUSERINFO_5(a,b,c,d,e)
#define BJLOGUSERINFO_6(a,b,c,d,e,f)
#define BJLOGUSERINFO_7(a,b,c,d,e,f,g)
#define BJLOGTRACE(msg)		
#define BJLOGTRACE_1(a)		
#define BJLOGTRACE_2(a,b)
#define BJLOGTRACE_3(a,b,c)
#define BJLOGDATA(data, len, msg) 
#define BJLOGDIAG(msg)	
#define BJLOGDIAG_1(a)		
#define BJLOGDIAG_2(a,b)
#define BJLOGDIAG_3(a,b,c)
#define BJLOGOUTPUT(buff, len)  
#define BJLOGINPUT(buff, len)  
#define BJLOGLEVEL1_1(a)
#define BJLOGLEVEL1_2(a,b)
#define BJLOGLEVEL1_3(a,b,c)
#define BJLOGLEVEL2_1(a)
#define BJLOGLEVEL2_2(a,b)
#define BJLOGLEVEL2_3(a,b,c)
#define BJLOGLEVEL3_1(a)
#define BJLOGLEVEL3_2(a,b)
#define BJLOGLEVEL3_3(a,b,c)
#define BJLOGLEVEL4_1(a)
#define BJLOGLEVEL4_2(a,b)
#define BJLOGLEVEL4_3(a,b,c)
#define BJLOGLEVEL5_1(a)
#define BJLOGLEVEL5_2(a,b)
#define BJLOGLEVEL5_3(a,b,c)
#define BJLOGLEVEL5_4(a,b,c,d)
#define BJLOGLEVEL5_5(a,b,c,d,e)
#define BJLOGLEVEL6_1(a)
#define BJLOGLEVEL6_2(a,b)
#define BJLOGLEVEL6_3(a,b,c)
#define BJLOGLEVEL7_1(a)
#define BJLOGLEVEL7_2(a,b)
#define BJLOGLEVEL7_3(a,b,c)
#define BJLOGLEVEL8_1(a)
#define BJLOGLEVEL8_2(a,b)
#define BJLOGLEVEL8_3(a,b,c)
#define BJLOGLEVEL9_1(a)
#define BJLOGLEVEL9_2(a,b)
#define BJLOGLEVEL9_3(a,b,c)
#define BJLOGLEVEL10_1(a)
#define BJLOGLEVEL10_2(a,b)
#define BJLOGLEVEL10_3(a,b,c)
#define BJLOGLEVEL11_1(a)
#define BJLOGLEVEL11_2(a,b)
#define BJLOGLEVEL11_3(a,b,c)


#endif // _NOBJLOGGING


#ifdef _DEBUG
#define BJLOGERRNO(msg, err) BJLogErrorNo(BJ_APP, __FILE__, __LINE__, TYPE_ERROR|NONFATAL, msg, err, TRUE)
#else
#define BJLOGERRNO(msg, err) BJLogErrorNo(BJ_APP, __FILE__, __LINE__, TYPE_ERROR|NONFATAL, msg, err, FALSE)
#endif

#define BJLOGERROR_(type, msg)  BJLogMessage(BJ_APP, __FILE__, __LINE__, type|TYPE_ERROR|NONFATAL, msg)
#define BJLOGINFO_(type, msg)  BJLogMessage(BJ_APP, __FILE__, __LINE__, type|TYPE_TRACE|INFO, msg)
#define BJLOGTRACE_(type, msg)  BJLogMessage(BJ_APP, __FILE__, __LINE__, type|TYPE_TRACE|LEVEL1, msg)
#define BJLOGDIAG_(type, msg)  BJLogMessage(BJ_APP, __FILE__, __LINE__, type|TYPE_TRACE|LEVEL5, msg)
#define BJLOGDATA_(type, data, len, msg) BJLogDiag(BJ_APP, __FILE__, __LINE__, (LPVOID)data, (WORD)len, \
				BJD_COMBI, type|TYPE_DIAG|LEVEL6, msg)
#define BJLOGOUTPUT_(type, buff, len)  BJLogDiag(BJ_APP, __FILE__, __LINE__, (LPVOID)buff, (WORD)len, \
				BJD_COMBI, type|TYPE_TRACE|LEVEL4, \
				(type)==FMTTYPE ? "Output data (%1!d! bytes):" : "Output data (%d bytes):", len)
#define BJLOGINPUT_(type, buff, len)  BJLogDiag(BJ_APP, __FILE__, __LINE__, (LPVOID)buff, (WORD)len, \
				BJD_COMBI, type|TYPE_TRACE|LEVEL4, \
				(type)==FMTTYPE ? "Input data (%1!d! bytes):" : "Input data (%d bytes):", len)

#ifdef _DEBUG
#define BJLOGERRNO_(type, msg, err) BJLogErrorNo(BJ_APP, __FILE__, __LINE__, type|TYPE_ERROR|NONFATAL, \
				msg, err, TRUE)
#else
#define BJLOGERRNO_(type, msg, err) BJLogErrorNo(BJ_APP, __FILE__, __LINE__, type|TYPE_ERROR|NONFATAL, \
				msg, err, FALSE)
#endif

#endif //WIN32
