-- This script will install a SQLCLR Table-Valued Function, 
-- that gives you direct access to a SQL Server Compact table
-- from any SQL Server script/stored procedure

-- C# source is available here: https://github.com/ErikEJ/SqlCeToolbox/blob/master/src/SqlCeCLR/SqlCeCLR.cs


-- A: Configuration Region

-- Uncomment and run below statements if the SQL Server database is not configured for the SQLCLR feature
-- Replace "MyDatabase" with the name of your database

--ALTER DATABASE [MyDatabase] SET TRUSTWORTHY ON;
--GO
--EXEC sp_configure 'clr enabled', '1';
--GO
--RECONFIGURE
--GO


-- B: Install Region (only required once per user database)

IF EXISTS (SELECT * FROM sys.procedures WHERE ([name] = N'GetSqlCeTable'))
  DROP PROCEDURE dbo.GetSqlCeTable;
GO

IF EXISTS (SELECT [name] FROM sys.assemblies WHERE [name] = N'SqlCeCLR')
  DROP ASSEMBLY SqlCeCLR;
GO

CREATE ASSEMBLY [SqlCeCLR]
FROM 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
WITH PERMISSION_SET = UNSAFE
GO

CREATE PROCEDURE dbo.GetSqlCeTable(@connectionstring nvarchar(256), @tableName nvarchar(128))
AS EXTERNAL NAME SqlCeCLR.[ErikEJ.SqlCe.ClrAccess].GetTable
GO

-- C: Test/Sample use Region

--use: "Provider=Microsoft.SQLSERVER.MOBILE.OLEDB.3.0;OLE DB Services=-4;" for SQL Compact 3.1
--use: "Provider=Microsoft.SQLSERVER.CE.OLEDB.3.5;OLE DB Services=-4;" for SQL Compact 3.5 SP2
--use: "Provider=Microsoft.SQLSERVER.CE.OLEDB.4.0;OLE DB Services=-4;" for SQL Compact 4.0

-- Sample 1: Getting the data
