﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data.SqlServerCe;
using System.IO;

namespace LoadToolboxUsage
{
    class Program
    {
        static void Main(string[] args)
        {
            const string log = "ToolboxLog.sdf";
            string connStr = "Data Source=" + log;

            string query = @"SELECT SUM(1) AS Uses, Feature
FROM UsageLog
GROUP BY Feature
ORDER BY Uses DESC;";
            
            if (File.Exists(log))
                File.Delete(log);

            using (SqlCeEngine engine = new SqlCeEngine(connStr))
            {
                engine.CreateDatabase();
            }

            using (SqlCeConnection conn = new SqlCeConnection(connStr))
            {
                using (SqlCeCommand cmd = new SqlCeCommand("CREATE TABLE UsageLog (Id INT IDENTITY NOT NULL, Feature nvarchar(40) NOT NULL, Date datetime NOT NULL)", conn))
                {
                    conn.Open();
                    cmd.ExecuteNonQuery();
                }
            }

            var files = Directory.EnumerateFiles(@"C:\Users\erik.COMMENTOR\Downloads", "SqlCeToolboxLog*.txt", SearchOption.TopDirectoryOnly);

            SqlCeConnection con = new SqlCeConnection(connStr);
            con.Open();
            foreach (var file in files)
            {
                var lines = File.ReadLines(file);
                foreach (var line in lines)
                {
                    string[] values = line.Split(';');
                    if (values.Count() == 2)
                    { 
                        DateTime date;
                        DateTime.TryParse(values[1], out date);
                        InsertLine(values[0], date, con);
                    }
                }
            }
        }

        private static void InsertLine(string feature, DateTime date, SqlCeConnection conn)
        {
            string insert = @"INSERT INTO [UsageLog]
           ([Feature]
           ,[Date]
            )
             VALUES (@feature, @date);";

            using (SqlCeCommand cmd = new SqlCeCommand())
            {
                cmd.Connection = conn;
                cmd.CommandText = insert;
                cmd.Parameters.Add(new SqlCeParameter("@feature", feature));
                cmd.Parameters.Add(new SqlCeParameter("@date", date));
                cmd.ExecuteNonQuery();
            }
        }

    }
}
